<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Biodata - Profil Tiara</title>
    <style>
        :root {
            --bg: #0e0a1f;
            --card: rgba(255, 255, 255, 0.06);
            --border: rgba(255, 255, 255, 0.12);
            --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            font-family: 'Segoe UI', system-ui, sans-serif;
            background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                        radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                        radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                        var(--bg);
            color: #e5e7eb;
            min-height: 100vh;
        }

        nav {
            position: sticky;
            top: 0;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 16px 32px;
            backdrop-filter: blur(16px);
            background: rgba(12, 10, 25, 0.7);
            border-bottom: 1px solid var(--border);
        }
        nav .logo { font-weight: 800; letter-spacing: 0.08em; color: #f8fafc; }
        nav a {
            margin-left: 16px;
            text-decoration: none;
            color: #e5e7eb;
            font-weight: 600;
            padding: 10px 14px;
            border-radius: 12px;
        }
        nav a:hover { background: rgba(255,255,255,0.08); }

        .layout {
            max-width: 1100px;
            margin: 32px auto 60px;
            padding: 0 24px;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 24px;
        }

        .card {
            background: var(--card);
            border: 1px solid var(--border);
            border-radius: 22px;
            padding: 26px;
            box-shadow: var(--glow);
            backdrop-filter: blur(12px);
        }

        .header {
            grid-column: 1 / -1;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
            gap: 24px;
            align-items: center;
        }

        .avatar {
            width: 240px;
            height: 240px;
            border-radius: 22px;
            object-fit: cover;
            border: 1px solid var(--border);
            box-shadow: var(--glow);
            animation: float 6s ease-in-out infinite;
        }

        h1 { margin: 0 0 8px; color: #f8fafc; font-size: 34px; }
        .subtitle { color: #cbd5e1; margin: 0 0 16px; }
        .eyebrow { letter-spacing: 0.08em; text-transform: uppercase; font-size: 12px; color: #fbcfe8; margin: 0 0 10px; }

        table { width: 100%; border-collapse: collapse; margin-top: 8px; }
        td { padding: 8px 0; color: #e7e9ef; }
        td:first-child { width: 160px; color: #cbd5e1; font-weight: 700; }

        .contact {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 12px;
            margin-top: 12px;
        }
        .pill {
            padding: 10px 12px;
            border-radius: 12px;
            border: 1px solid var(--border);
            background: rgba(255,255,255,0.05);
            color: #f8fafc;
            font-weight: 700;
        }

        footer {
            text-align: center;
            padding: 18px;
            color: #cbd5e1;
            border-top: 1px solid var(--border);
            background: rgba(12, 10, 25, 0.7);
        }

        @media (max-width: 720px) {
            nav { padding: 12px 18px; }
            .layout { padding: 0 18px; }
            nav { flex-direction: column; align-items: flex-start; gap: 8px; }
            nav a { margin-left: 0; }
            .avatar { width: 180px; height: 180px; }
            .card { padding: 20px; }
        }

        @keyframes float {
            0%, 100% { transform: translateY(0) scale(1); }
            50% { transform: translateY(-10px) scale(1.01); }
        }
    </style>
</head>
<body>

<nav>
    <div class="logo">PROFIL TIARA</div>
    <div>
        <a href="/">Home</a>
        <a href="/biodata">Biodata</a>
        <a href="/pendidikan">Pendidikan</a>
        <a href="/aktivitas">Aktivitas</a>
    </div>
</nav>

<div class="layout">
    <div class="card header">
        <div>
            <p class="eyebrow">Profil</p>
            <h1><?= esc($nama ?? 'Tiara Cahya Kurniawati') ?></h1>
            <p class="subtitle">Mahasiswa <?= esc($prodi ?? 'Ilmu Komputer') ?> · <?= esc($universitas ?? 'Universitas Yatsi Madani') ?></p>
            <div class="contact">
                <div class="pill">Tangerang, Banten</div>
                <div class="pill"><?= esc($email ?? 'tiara@email.com') ?></div>
                <div class="pill"><?= esc($no_hp ?? '0812-xxxx-xxxx') ?></div>
            </div>
        </div>
        <div style="text-align:center;">
            <img src="<?= base_url('img/tiara.jpg') ?>" alt="Foto Tiara" class="avatar">
        </div>
    </div>

    <div class="card">
        <p class="eyebrow">Data Personal</p>
        <table>
            <tr><td>Nama</td><td><?= esc($nama ?? 'Tiara Cahya Kurniawati') ?></td></tr>
            <tr><td>Tempat, Tanggal Lahir</td><td><?= esc(($tempat_lahir ?? 'Tangerang').', '.($tanggal_lahir ?? '28 Desember 2004')) ?></td></tr>
            <tr><td>Alamat</td><td><?= esc($alamat ?? 'Tangerang, Banten') ?></td></tr>
            <tr><td>Jenis Kelamin</td><td>Perempuan</td></tr>
            <tr><td>Program Studi</td><td><?= esc($prodi ?? 'Ilmu Komputer') ?></td></tr>
            <tr><td>Universitas</td><td><?= esc($universitas ?? 'Universitas Yatsi Madani') ?></td></tr>
        </table>
    </div>

    <div class="card">
        <p class="eyebrow">Kontak</p>
        <table>
            <tr><td>Email</td><td><?= esc($email ?? 'tiarachya888@email.com') ?></td></tr>
            <tr><td>No. HP</td><td><?= esc($no_hp ?? '081292859846') ?></td></tr>
        </table>
    </div>
</div>

<footer>
    © <?= date('Y') ?> Tiara Cahya Kurniawati · Universitas Yatsi Madani
</footer>

</body>
</html>
