<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="dashboard-page">
    <div class="container-fluid">
        <div class="hero d-flex flex-column flex-xl-row align-items-start align-items-xl-center justify-content-between mb-4">
            <div class="hero-copy">
                <p class="eyebrow">Admin Panel</p>
                <h1>Selamat datang, <?= esc($admin_username ?? 'Admin') ?> &#128075;</h1>
                <p class="subtitle">Kelola konten, pantau data, dan lakukan aksi cepat dari satu tempat.</p>
                <div class="hero-actions">
                    <a class="btn btn-primary btn-cta" href="<?= base_url('admin/biodata') ?>">
                        <i class="bi bi-pencil-square me-2"></i>Kelola Profil
                    </a>
                    <a class="btn btn-outline-light btn-ghost" href="<?= base_url('admin/logout') ?>">
                        <i class="bi bi-box-arrow-right me-2"></i>Logout
                    </a>
                </div>
            </div>
            <div class="hero-visual mt-4 mt-xl-0">
                <div class="visual-card">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="badge badge-soft">Status</span>
                        <i class="bi bi-shield-check text-success"></i>
                    </div>
                    <h4 class="mb-1">Akun Aktif</h4>
                    <p class="small text-muted mb-3">Semua sistem berjalan normal.</p>
                    <div class="progress-stats">
                        <div>
                            <p class="label">Progres Harian</p>
                            <div class="progress">
                                <div class="progress-bar bg-info" role="progressbar" style="width: 72%"></div>
                            </div>
                        </div>
                        <div class="text-end">
                            <h3 class="mb-0">72%</h3>
                            <small class="text-muted">target tercapai</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-3 stats-row">
            <div class="col-12 col-md-6 col-xl-3">
                <div class="stat-card glass">
                    <div class="stat-icon bg-gradient-pink"><i class="bi bi-people-fill"></i></div>
                    <div>
                        <p class="label">Biodata</p>
                        <h2 class="mb-0"><?= esc($stat_biodata ?? 0) ?></h2>
                        <small class="text-muted">Profil aktif</small>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6 col-xl-3">
                <div class="stat-card glass">
                    <div class="stat-icon bg-gradient-purple"><i class="bi bi-book-half"></i></div>
                    <div>
                        <p class="label">Pendidikan</p>
                        <h2 class="mb-0"><?= esc($stat_pendidikan ?? 0) ?></h2>
                        <small class="text-muted">Riwayat tersimpan</small>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6 col-xl-3">
                <div class="stat-card glass">
                    <div class="stat-icon bg-gradient-blue"><i class="bi bi-activity"></i></div>
                    <div>
                        <p class="label">Aktivitas</p>
                        <h2 class="mb-0"><?= esc($stat_aktivitas ?? 0) ?></h2>
                        <small class="text-muted">Total log</small>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6 col-xl-3">
                <div class="stat-card glass">
                    <div class="stat-icon bg-gradient-green"><i class="bi bi-clock-history"></i></div>
                    <div>
                        <p class="label">Terakhir Masuk</p>
                        <h2 class="mb-0"><?= esc($last_login ?? date('d M Y')) ?></h2>
                        <small class="text-muted">Session aktif</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-3 mt-2">
            <div class="col-12 col-lg-7">
                <div class="card glass card-action">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div>
                            <p class="label mb-1">Aksi Cepat</p>
                            <h5 class="mb-0">Mulai dari sini</h5>
                        </div>
                        <i class="bi bi-lightning-charge-fill text-warning fs-4"></i>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12 col-md-4">
                                <a class="action-tile" href="<?= base_url('admin/biodata') ?>">
                                    <div class="tile-icon"><i class="bi bi-person-lines-fill"></i></div>
                                    <div>
                                        <h6 class="mb-1">Kelola Biodata</h6>
                                        <small class="text-muted">Perbarui informasi utama</small>
                                    </div>
                                    <i class="bi bi-arrow-right-circle ms-auto"></i>
                                </a>
                            </div>
                            <div class="col-12 col-md-4">
                                <a class="action-tile" href="<?= base_url('admin/pendidikan') ?>">
                                    <div class="tile-icon"><i class="bi bi-journal-text"></i></div>
                                    <div>
                                        <h6 class="mb-1">Data Pendidikan</h6>
                                        <small class="text-muted">Tambah & edit riwayat</small>
                                    </div>
                                    <i class="bi bi-arrow-right-circle ms-auto"></i>
                                </a>
                            </div>
                            <div class="col-12 col-md-4">
                                <a class="action-tile" href="<?= base_url('admin/aktivitas') ?>">
                                    <div class="tile-icon"><i class="bi bi-list-check"></i></div>
                                    <div>
                                        <h6 class="mb-1">Aktivitas Harian</h6>
                                        <small class="text-muted">Catat aktivitas terbaru</small>
                                    </div>
                                    <i class="bi bi-arrow-right-circle ms-auto"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-lg-5">
                <div class="card glass card-list">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div>
                            <p class="label mb-1">Ringkasan</p>
                            <h5 class="mb-0">Progress terbaru</h5>
                        </div>
                        <i class="bi bi-graph-up-arrow text-success fs-4"></i>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex align-items-start">
                            <div class="bullet bg-gradient-blue"></div>
                            <div>
                                <p class="mb-1 fw-semibold">Update biodata selesai</p>
                                <small class="text-muted">2 jam lalu</small>
                            </div>
                            <span class="ms-auto badge bg-light text-dark">Sukses</span>
                        </li>
                        <li class="list-group-item d-flex align-items-start">
                            <div class="bullet bg-gradient-purple"></div>
                            <div>
                                <p class="mb-1 fw-semibold">Tambah riwayat pendidikan</p>
                                <small class="text-muted">Kemarin</small>
                            </div>
                            <span class="ms-auto badge bg-light text-dark">3 item</span>
                        </li>
                        <li class="list-group-item d-flex align-items-start">
                            <div class="bullet bg-gradient-green"></div>
                            <div>
                                <p class="mb-1 fw-semibold">Aktivitas mingguan diperbarui</p>
                                <small class="text-muted">3 hari lalu</small>
                            </div>
                            <span class="ms-auto badge bg-light text-dark">18 log</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
:root {
    --bg: #0e0a1f;
    --card: rgba(255, 255, 255, 0.05);
    --border: rgba(255, 255, 255, 0.09);
    --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
}

body {
    background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                var(--bg);
    color: #e5e7eb;
}

.dashboard-page {
    padding: 24px;
}

.dashboard-page h1,
.dashboard-page h2,
.dashboard-page h3,
.dashboard-page h4,
.dashboard-page h5,
.dashboard-page h6 {
    color: #f8fafc;
}

.dashboard-page p,
.dashboard-page small {
    color: #e7e9ef;
}

.dashboard-page .text-muted {
    color: #e2e8f0 !important;
}

.hero {
    background: linear-gradient(135deg, rgba(236,72,153,0.28), rgba(139,92,246,0.28));
    border: 1px solid var(--border);
    border-radius: 20px;
    padding: 28px;
    box-shadow: var(--glow);
    position: relative;
    overflow: hidden;
}

.hero::after {
    content: "";
    position: absolute;
    right: -60px;
    bottom: -80px;
    width: 240px;
    height: 240px;
    background: radial-gradient(circle, rgba(139,92,246,0.38), transparent 60%);
    filter: blur(12px);
}

.hero-copy h1 {
    font-weight: 700;
    color: #f8fafc;
}

.eyebrow {
    letter-spacing: 0.1em;
    text-transform: uppercase;
    font-size: 0.8rem;
    color: #fbcfe8;
    margin-bottom: 6px;
}

.subtitle {
    color: #cbd5e1;
    max-width: 520px;
}

.hero-actions .btn {
    margin-right: 10px;
    border-radius: 12px;
    font-weight: 600;
}

.btn-cta {
    background: linear-gradient(135deg, #ec4899, #8b5cf6);
    border: none;
}

.btn-cta:hover {
    filter: brightness(1.05);
}

.btn-ghost {
    color: #e5e7eb;
    border: 1px solid rgba(255,255,255,0.15);
}

.hero-visual .visual-card {
    background: rgba(255,255,255,0.06);
    border: 1px solid var(--border);
    border-radius: 16px;
    padding: 18px;
    min-width: 260px;
    backdrop-filter: blur(8px);
}

.badge-soft {
    background: rgba(232,121,249,0.18);
    color: #fbcfe8;
    border-radius: 12px;
    padding: 6px 10px;
    font-weight: 600;
}

.progress-stats {
    display: flex;
    align-items: flex-end;
    gap: 16px;
}

.progress {
    height: 8px;
    background-color: rgba(255,255,255,0.08);
}

.progress-bar {
    border-radius: 999px;
    background: linear-gradient(135deg, #ec4899, #8b5cf6);
}

.stats-row .stat-card {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 16px;
    padding: 18px;
    display: flex;
    align-items: center;
    gap: 14px;
    backdrop-filter: blur(6px);
    transition: transform 0.25s ease, box-shadow 0.25s ease;
}

.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 16px 36px rgba(0,0,0,0.35);
}

.stat-icon {
    width: 46px;
    height: 46px;
    border-radius: 14px;
    display: grid;
    place-items: center;
    color: white;
    font-size: 1.2rem;
}

.label {
    text-transform: uppercase;
    letter-spacing: 0.08em;
    color: #cbd5e1;
    font-size: 0.78rem;
    margin-bottom: 4px;
}

.bg-gradient-pink { background: linear-gradient(135deg, #f472b6, #ec4899); }
.bg-gradient-purple { background: linear-gradient(135deg, #c084fc, #8b5cf6); }
.bg-gradient-blue { background: linear-gradient(135deg, #a855f7, #6b21a8); }
.bg-gradient-green { background: linear-gradient(135deg, #f9a8d4, #ec4899); }

.card.glass {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 18px;
    box-shadow: var(--glow);
    backdrop-filter: blur(10px);
}

.card-action .action-tile {
    display: flex;
    align-items: center;
    gap: 12px;
    background: rgba(255,255,255,0.04);
    border: 1px solid var(--border);
    border-radius: 14px;
    padding: 14px;
    color: #e5e7eb;
    text-decoration: none;
    transition: transform 0.2s ease, border 0.2s ease, background 0.2s ease, box-shadow 0.2s ease;
    box-shadow: 0 12px 30px rgba(236, 72, 153, 0.08);
}

.action-tile:hover {
    transform: translateY(-3px);
    border-color: rgba(255,255,255,0.25);
    background: rgba(255,255,255,0.09);
    box-shadow: 0 14px 36px rgba(139, 92, 246, 0.18);
}

.tile-icon {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    display: grid;
    place-items: center;
    background: rgba(255,255,255,0.1);
    color: #a5b4fc;
}

.card-list .list-group-item {
    background: transparent;
    color: #e5e7eb;
    border-color: var(--border);
}

.bullet {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    margin-right: 10px;
    margin-top: 4px;
}

@media (max-width: 768px) {
    .dashboard-page {
        padding: 18px 14px 40px;
    }
    .hero {
        padding: 22px;
    }
    .hero-actions .btn {
        width: 100%;
        margin: 6px 0;
    }
    .hero-visual {
        width: 100%;
    }
    .progress-stats {
        flex-direction: column;
        align-items: flex-start;
    }
}
</style>

<?= $this->endSection() ?>
