<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="biodata-page">
    <div class="container-fluid">
        <div class="hero-bio d-flex flex-column flex-lg-row align-items-start align-items-lg-center justify-content-between mb-4">
            <div>
                <p class="eyebrow">Profil</p>
                <h2 class="mb-1">Biodata Admin</h2>
                <p class="subtitle">Lihat dan perbarui informasi utama.</p>
            </div>
            <div class="d-flex flex-wrap gap-2 mt-3 mt-lg-0">
                <a href="<?= base_url('admin/biodata/edit/'.$row['id']) ?>" class="btn btn-cta">
                    <i class="bi bi-pencil-square me-2"></i>Edit Biodata
                </a>
                <a href="<?= base_url('admin/dashboard') ?>" class="btn btn-ghost">
                    <i class="bi bi-arrow-left me-2"></i>Kembali ke Dashboard
                </a>
            </div>
        </div>

        <div class="card glass profile-card mb-4">
            <div class="row g-4 align-items-center">
                <div class="col-12 col-md-4 text-center">
                    <?php if($row['foto']): ?>
                        <img src="<?= base_url('uploads/biodata/'.$row['foto']) ?>"
                             class="avatar shadow"
                             alt="Foto profil">
                    <?php else: ?>
                        <div class="avatar placeholder d-grid align-items-center justify-content-center">
                            <i class="bi bi-person-fill fs-1 text-muted"></i>
                            <small class="text-muted">Belum ada foto</small>
                        </div>
                    <?php endif ?>
                </div>
                <div class="col-12 col-md-8">
                    <div class="info-grid">
                        <div>
                            <p class="label">Nama</p>
                            <h5><?= esc($row['nama']) ?></h5>
                        </div>
                        <div>
                            <p class="label">TTL</p>
                            <h5><?= esc($row['ttl']) ?></h5>
                        </div>
                        <div>
                            <p class="label">Alamat</p>
                            <h5><?= esc($row['alamat']) ?></h5>
                        </div>
                        <div>
                            <p class="label">Email</p>
                            <h5><?= esc($row['email']) ?></h5>
                        </div>
                        <div>
                            <p class="label">No HP</p>
                            <h5><?= esc($row['no_hp']) ?></h5>
                        </div>
                        <div>
                            <p class="label">Gender</p>
                            <h5><?= esc($row['jenis_kelamin']) ?></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
:root {
    --bg: #0e0a1f;
    --card: rgba(255, 255, 255, 0.05);
    --border: rgba(255, 255, 255, 0.08);
    --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
}

body {
    background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                var(--bg);
    color: #e5e7eb;
}

.biodata-page {
    padding: 24px;
}

.biodata-page h1,
.biodata-page h2,
.biodata-page h3,
.biodata-page h4,
.biodata-page h5,
.biodata-page h6 {
    color: #f8fafc;
}

.biodata-page p,
.biodata-page small {
    color: #e7e9ef;
}

.biodata-page .text-muted {
    color: #e2e8f0 !important;
}

.hero-bio {
    background: linear-gradient(135deg, rgba(236,72,153,0.26), rgba(139,92,246,0.26));
    border: 1px solid var(--border);
    border-radius: 18px;
    padding: 22px;
    box-shadow: var(--glow);
}

.eyebrow {
    letter-spacing: 0.1em;
    text-transform: uppercase;
    font-size: 0.82rem;
    color: #fbcfe8;
    margin-bottom: 6px;
}

.subtitle {
    color: #cbd5e1;
    max-width: 520px;
}

.btn-cta {
    background: linear-gradient(135deg, #ec4899, #8b5cf6);
    border: none;
    color: #fff;
    border-radius: 12px;
    font-weight: 700;
}

.btn-cta:hover { filter: brightness(1.05); }

.btn-ghost {
    color: #e5e7eb;
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 12px;
    font-weight: 600;
}

.glass {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 18px;
    box-shadow: var(--glow);
    backdrop-filter: blur(10px);
}

.profile-card {
    padding: 22px;
}

.avatar {
    width: 190px;
    height: 190px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid rgba(255,255,255,0.18);
}

.avatar.placeholder {
    width: 190px;
    height: 190px;
    border: 2px dashed rgba(255,255,255,0.25);
    border-radius: 50%;
}

.label {
    text-transform: uppercase;
    letter-spacing: 0.08em;
    color: #cbd5e1;
    font-size: 0.78rem;
    margin-bottom: 4px;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 14px 18px;
}

@media (max-width: 768px) {
    .biodata-page { padding: 18px 14px 32px; }
    .hero-bio { padding: 18px; }
    .avatar,
    .avatar.placeholder { width: 150px; height: 150px; }
}
</style>

<?= $this->endSection() ?>
