<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<div class="biodata-page">
    <div class="container-fluid">
        <div class="hero-bio d-flex flex-column flex-lg-row align-items-start align-items-lg-center justify-content-between mb-4">
            <div>
                <p class="eyebrow">Profil</p>
                <h2 class="mb-1">Edit Biodata</h2>
                <p class="subtitle">Perbarui informasi utama.</p>
            </div>
            <a href="<?= base_url('admin/biodata') ?>" class="btn btn-ghost mt-3 mt-lg-0">
                <i class="bi bi-arrow-left me-2"></i>Kembali
            </a>
        </div>

        <div class="card glass form-card">
            <form action="<?= base_url('admin/biodata/update/'.$row['id']) ?>"
                  method="post" enctype="multipart/form-data" class="row g-3">

                <input type="hidden" name="foto_lama" value="<?= $row['foto'] ?>">

                <div class="col-12 col-lg-6">
                    <label class="form-label">Nama</label>
                    <input type="text" name="nama" class="form-control" value="<?= esc($row['nama']) ?>">
                </div>
                <div class="col-12 col-lg-6">
                    <label class="form-label">TTL</label>
                    <input type="text" name="ttl" class="form-control" value="<?= esc($row['ttl']) ?>">
                </div>
                <div class="col-12">
                    <label class="form-label">Alamat</label>
                    <input type="text" name="alamat" class="form-control" value="<?= esc($row['alamat']) ?>">
                </div>
                <div class="col-12 col-lg-6">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" value="<?= esc($row['email']) ?>">
                </div>
                <div class="col-12 col-lg-6">
                    <label class="form-label">No HP</label>
                    <input type="text" name="no_hp" class="form-control" value="<?= esc($row['no_hp']) ?>">
                </div>
                <div class="col-12 col-lg-6">
                    <label class="form-label">Jenis Kelamin</label>
                    <select name="jenis_kelamin" class="form-select">
                        <option <?= $row['jenis_kelamin']=='Perempuan'?'selected':'' ?>>Perempuan</option>
                        <option <?= $row['jenis_kelamin']=='Laki-laki'?'selected':'' ?>>Laki-laki</option>
                    </select>
                </div>
                <div class="col-12 col-lg-6">
                    <label class="form-label">Foto</label>
                    <input type="file" name="foto" class="form-control">
                    <?php if($row['foto']): ?>
                        <small class="text-muted d-block mt-2">Foto saat ini: <?= esc($row['foto']) ?></small>
                    <?php endif ?>
                </div>

                <div class="col-12 d-flex gap-2 mt-2">
                    <button class="btn btn-cta" type="submit">
                        <i class="bi bi-check2-circle me-2"></i>Simpan
                    </button>
                    <a href="<?= base_url('admin/biodata') ?>" class="btn btn-ghost">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
:root {
    --bg: #0e0a1f;
    --card: rgba(255, 255, 255, 0.05);
    --border: rgba(255, 255, 255, 0.08);
    --glow: 0 18px 50px rgba(139, 92, 246, 0.28);
}

body {
    background: radial-gradient(circle at 20% 20%, rgba(236, 72, 153, 0.18), transparent 24%),
                radial-gradient(circle at 80% 15%, rgba(139, 92, 246, 0.18), transparent 24%),
                radial-gradient(circle at 45% 85%, rgba(236, 72, 153, 0.12), transparent 24%),
                var(--bg);
    color: #e5e7eb;
}

.biodata-page { padding: 24px; }

.biodata-page h1,
.biodata-page h2,
.biodata-page h3,
.biodata-page h4,
.biodata-page h5,
.biodata-page h6 {
    color: #f8fafc;
}

.biodata-page p,
.biodata-page small {
    color: #e7e9ef;
}

.biodata-page .text-muted {
    color: #e2e8f0 !important;
}

.hero-bio {
    background: linear-gradient(135deg, rgba(236,72,153,0.26), rgba(139,92,246,0.26));
    border: 1px solid var(--border);
    border-radius: 18px;
    padding: 22px;
    box-shadow: var(--glow);
}

.eyebrow {
    letter-spacing: 0.1em;
    text-transform: uppercase;
    font-size: 0.82rem;
    color: #fbcfe8;
    margin-bottom: 6px;
}

.subtitle { color: #cbd5e1; max-width: 520px; }

.btn-cta {
    background: linear-gradient(135deg, #ec4899, #8b5cf6);
    border: none;
    color: #fff;
    border-radius: 12px;
    font-weight: 700;
}
.btn-cta:hover { filter: brightness(1.05); }

.btn-ghost {
    color: #e5e7eb;
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 12px;
    font-weight: 600;
}

.glass {
    background: var(--card);
    border: 1px solid var(--border);
    border-radius: 18px;
    box-shadow: var(--glow);
    backdrop-filter: blur(10px);
}

.form-card {
    padding: 22px;
}

.form-label { color: #e5e7eb; font-weight: 600; }

.form-control, .form-select {
    background: rgba(255,255,255,0.04);
    border: 1px solid var(--border);
    color: #e5e7eb;
}

.form-control:focus, .form-select:focus {
    border-color: rgba(236,72,153,0.6);
    box-shadow: 0 0 0 0.2rem rgba(236,72,153,0.18);
    background: rgba(255,255,255,0.08);
}

@media (max-width: 768px) {
    .biodata-page { padding: 18px 14px 32px; }
    .hero-bio { padding: 18px; }
}
</style>

<?= $this->endSection() ?>
