<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\PendidikanModel;

class Pendidikan extends BaseController
{
    protected $pendidikan;

    public function __construct()
    {
        $this->pendidikan = new PendidikanModel();
    }

    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $urut    = $this->request->getGet('urut') ?? 'DESC';

        if ($keyword) {
            $pendidikan = $this->pendidikan
                ->like('nama_sekolah', $keyword)
                ->orderBy('tahun_mulai', $urut)
                ->paginate(5);
        } else {
            $pendidikan = $this->pendidikan
                ->orderBy('tahun_mulai', $urut)
                ->paginate(5);
        }

        return view('admin/pendidikan/index', [
            'pendidikan' => $pendidikan,
            'pager'      => $this->pendidikan->pager,
            'keyword'    => $keyword ?? '',
            'urut'       => $urut
        ]);
    }

    public function create()
    {
        return view('admin/pendidikan/create');
    }

    public function store()
    {
        $foto = $this->request->getFile('foto');
        $namaFoto = null;
        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            $namaFoto = $foto->getRandomName();
            $foto->move('uploads/pendidikan', $namaFoto);
        }

        $this->pendidikan->insert([
            'jenjang'       => $this->request->getPost('jenjang'),
            'nama_sekolah'  => $this->request->getPost('nama_sekolah'),
            'tahun_mulai'   => $this->request->getPost('tahun_mulai'),
            'tahun_selesai' => $this->request->getPost('tahun_selesai'),
            'foto'          => $namaFoto
        ]);
        return redirect()->to(base_url('admin/pendidikan'));
    }

    public function edit($id)
    {
        return view('admin/pendidikan/edit', [
            'row' => $this->pendidikan->find($id)
        ]);
    }

    public function show($id)
    {
        $row = $this->pendidikan->find($id);

        if (!$row) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Data pendidikan tidak ditemukan");
        }

        return view('admin/pendidikan/show', ['row' => $row]);
    }

    public function update($id)
    {
        $row  = $this->pendidikan->find($id);
        $foto = $this->request->getFile('foto');
        $namaFoto = $row['foto'] ?? null;

        if ($foto && $foto->isValid() && !$foto->hasMoved()) {
            $namaFoto = $foto->getRandomName();
            $foto->move('uploads/pendidikan', $namaFoto);
        }

        $this->pendidikan->update($id, [
            'jenjang'       => $this->request->getPost('jenjang'),
            'nama_sekolah'  => $this->request->getPost('nama_sekolah'),
            'tahun_mulai'   => $this->request->getPost('tahun_mulai'),
            'tahun_selesai' => $this->request->getPost('tahun_selesai'),
            'foto'          => $namaFoto
        ]);
        return redirect()->to(base_url('admin/pendidikan'));
    }

    public function delete($id)
    {
        $this->pendidikan->delete($id);
        return redirect()->to(base_url('admin/pendidikan'));
    }
}
