<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class Biodata extends BaseController
{
    protected $biodata;

    public function __construct()
    {
        $this->biodata = new BiodataModel();
    }

    public function index()
    {
        return view('admin/biodata/index', [
            'row' => $this->biodata->first()
        ]);
    }

    public function edit($id)
    {
        return view('admin/biodata/edit', [
            'row' => $this->biodata->find($id)
        ]);
    }

    public function update($id)
    {
        $data = [
            'nama'          => $this->request->getPost('nama'),
            'alamat'        => $this->request->getPost('alamat'),
            'email'         => $this->request->getPost('email'),
            'no_hp'         => $this->request->getPost('no_hp'),
            'ttl'           => $this->request->getPost('ttl'),
            'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
        ];

        $foto = $this->request->getFile('foto');
        if ($foto && $foto->isValid()) {
            $namaFoto = $foto->getRandomName();
            $foto->move('uploads/biodata', $namaFoto);
            $data['foto'] = $namaFoto;
        }

        $this->biodata->update($id, $data);
        return redirect()->to(base_url('admin/biodata'));
    }
}
