<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;

class Aktivitas extends BaseController
{
    protected $aktivitas;

    public function __construct()
    {
        $this->aktivitas = new AktivitasModel();
    }

    // =====================
    // INDEX + SEARCH + PAGING
    // =====================
    public function index()
    {
        $keyword = $this->request->getGet('keyword');

        if ($keyword) {
            $data['aktivitas'] = $this->aktivitas
                ->like('nama_aktivitas', $keyword)
                ->orderBy('tanggal', 'DESC')
                ->paginate(5);
        } else {
            $data['aktivitas'] = $this->aktivitas
                ->orderBy('tanggal', 'DESC')
                ->paginate(5);
        }

        $data['pager']   = $this->aktivitas->pager;
        $data['keyword'] = $keyword ?? '';

        return view('admin/aktivitas/index', $data);
    }

    // =====================
    // CREATE
    // =====================
    public function create()
    {
        return view('admin/aktivitas/create');
    }

    public function store()
    {
        $media     = $this->request->getFile('media');
        $mediaName = null;

        if ($media && $media->isValid() && !$media->hasMoved()) {
            $mediaName = $media->getRandomName();
            $media->move('uploads/aktivitas', $mediaName);
        }

        $this->aktivitas->insert([
            'tanggal'        => $this->request->getPost('tanggal'),
            'jam'            => $this->request->getPost('jam'),
            'nama_aktivitas' => $this->request->getPost('nama_aktivitas'),
            'media'          => $mediaName
        ]);

        return redirect()->to(base_url('admin/aktivitas'));
    }

    // =====================
    // EDIT
    // =====================
    public function edit($id)
    {
        $data['row'] = $this->aktivitas->find($id);
        return view('admin/aktivitas/edit', $data);
    }

    // =====================
    // SHOW / PREVIEW
    // =====================
    public function show($id)
    {
        $row = $this->aktivitas->find($id);

        if (!$row) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Data aktivitas tidak ditemukan');
        }

        return view('admin/aktivitas/show', ['row' => $row]);
    }

    public function update($id)
    {
        $row       = $this->aktivitas->find($id);
        $media     = $this->request->getFile('media');
        $mediaName = $row['media'] ?? null;

        if ($media && $media->isValid() && !$media->hasMoved()) {
            $mediaName = $media->getRandomName();
            $media->move('uploads/aktivitas', $mediaName);
        }

        $this->aktivitas->update($id, [
            'tanggal'        => $this->request->getPost('tanggal'),
            'jam'            => $this->request->getPost('jam'),
            'nama_aktivitas' => $this->request->getPost('nama_aktivitas'),
            'media'          => $mediaName
        ]);

        return redirect()->to(base_url('admin/aktivitas'));
    }

    // =====================
    // DELETE
    // =====================
    public function delete($id)
    {
        $this->aktivitas->delete($id);
        return redirect()->to(base_url('admin/aktivitas'));
    }
}
