<?php
// Definisikan variabel warna baru sesuai palet yang diberikan
$color_d = '#00473e';   // Headline (Hijau Tua - Teks Pertanyaan)
$color_h = '#faae2b';   // Button/Highlight (Kuning Oranye - Ikon/Aksen Kuat)
$color_c = '#ffa8ba';   // Secondary (Pink Muda - Latar Belakang Jawaban/Aktif)

// Warna tambahan dari palet
$color_text = '#475d5b'; // Paragraph Text (Teks Jawaban)
$color_bg_body = '#f2f7f5'; // Background (Latar Belakang Body Jawaban)
$color_stroke = '#00332c'; // Stroke/Garis
?>

<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<style>
    /* Styling Kustom untuk FAQ Accordion */
    .faq-title {
        /* Judul utama menggunakan warna D (Hijau Tua) */
        color: <?php echo $color_d; ?>;
        font-weight: 700;
        margin-bottom: 30px;
        /* Aksen garis bawah Warna H (Kuning Oranye) */
        border-bottom: 3px solid <?php echo $color_h; ?>; 
        padding-bottom: 10px;
        text-align: center;
    }
    .faq-title i {
        /* Ikon pada judul menggunakan warna H (Kuning Oranye) */
        color: <?php echo $color_h; ?>;
    }
    .accordion-item {
        /* Border item menggunakan warna Stroke (Hijau Sangat Tua) */
        border: 1px solid <?php echo $color_stroke; ?>;
        margin-bottom: 10px;
        border-radius: 5px;
        overflow: hidden;
    }
    .accordion-button {
        /* Latar belakang tombol pertanyaan (non-aktif) */
        background-color: #fcfcfc;
        /* Teks pertanyaan menggunakan warna D (Hijau Tua) */
        color: <?php echo $color_d; ?>;
        font-weight: 600;
        padding: 15px 20px;
        width: 100%;
        text-align: left;
        border: none;
        transition: background-color 0.3s;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .accordion-button:hover {
        /* Hover state sedikit lebih cerah */
        background-color: <?php echo $color_bg_body; ?>; /* Menggunakan warna BG body baru */
    }
    .accordion-button[aria-expanded="true"] {
        /* Warna C (Pink Muda) saat aktif/terbuka */
        background-color: <?php echo $color_c; ?>; 
        color: <?php echo $color_d; ?>; /* Teks pertanyaan tetap D agar kontras dari warna C */
        /* Border bawah tombol aktif menggunakan warna H */
        border-bottom: 1px solid <?php echo $color_h; ?>; 
    }
    .accordion-icon {
        /* Ikon default menggunakan warna H (Kuning Oranye) */
        color: <?php echo $color_h; ?>;
        transition: transform 0.3s;
        font-size: 1.2rem;
    }
    .accordion-button[aria-expanded="true"] .accordion-icon {
        transform: rotate(180deg);
        /* Ikon saat aktif menggunakan warna D (Hijau Tua) agar kontras dengan latar C */
        color: <?php echo $color_d; ?>; 
    }
    .accordion-body {
        padding: 20px;
        /* Latar belakang jawaban menggunakan warna Background Body baru */
        background-color: <?php echo $color_bg_body; ?>; 
        /* Teks jawaban menggunakan warna Paragraph */
        color: <?php echo $color_text; ?>;
        line-height: 1.6;
    }
</style>

<div class="container py-5">
    
    <h1 class="faq-title">
        <i class="fas fa-question-circle"></i> Pertanyaan yang Sering Diajukan
    </h1>
    
    <div class="row justify-content-center">
        <div class="col-md-10 col-lg-8">
            <div class="accordion" id="faqAccordion">
                <?php $i = 1; ?>
                <?php foreach ($data_faqs as $faq) : ?>
                    <div class="accordion-item">
                        <h2 class="h5 accordion-header" id="heading_<?= $i ?>">
                            <button 
                                class="accordion-button collapsed" 
                                type="button" 
                                data-bs-toggle="collapse" 
                                data-bs-target="#collapse_<?= $i ?>" 
                                aria-expanded="false" 
                                aria-controls="collapse_<?= $i ?>"
                            >
                                <?= $faq['question'] ?>
                                <i class="fas fa-chevron-down accordion-icon"></i>
                            </button>
                        </h2>
                        
                        <div 
                            id="collapse_<?= $i ?>" 
                            class="accordion-collapse collapse" 
                            aria-labelledby="heading_<?= $i ?>" 
                            data-bs-parent="#faqAccordion"
                        >
                            <div class="accordion-body">
                                <?= $faq['answer'] ?>
                            </div>
                        </div>
                    </div>
                <?php $i++; ?>
                <?php endforeach; ?>
            </div>
            
            <?php if (empty($data_faqs)) : ?>
                <div class="text-center p-5 mt-4" style="border: 1px dashed <?php echo $color_c; ?>;">
                    <p class="lead" style="color: <?php echo $color_d; ?>;">Belum ada Pertanyaan yang Sering Diajukan.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>