<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin - SJ Portfolio</title>
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?= base_url('css/bootstrap.min.css') ?>" />
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Playfair+Display:wght@700&display=swap" rel="stylesheet">
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>

<body>

<?php
// Colors for consistency
$primary_color = '#645c55'; // Dark Brown
$accent_color = '#faae2b'; // Orange
$bg_color = '#f8f9fa';
?>

<style>
    /* Custom Login Page Styles */
    body {
        background-color:
            <?= $bg_color ?>
        ;
    }

    .login-container {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
    }

    .login-card {
        background: #ffffff;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
        overflow: hidden;
        width: 100%;
        max-width: 450px;
        transition: transform 0.3s ease;
        border: 1px solid rgba(0, 0, 0, 0.02);
    }

    .login-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 50px rgba(0, 0, 0, 0.12);
    }

    .login-header {
        background:
            <?= $primary_color ?>
        ;
        padding: 40px 30px;
        text-align: center;
        color: #fff;
        position: relative;
    }

    .login-header h2 {
        font-weight: 700;
        font-family: 'Playfair Display', serif;
        margin: 0;
        letter-spacing: 1px;
    }

    .login-header p {
        margin-top: 10px;
        opacity: 0.9;
        font-size: 0.95rem;
        font-weight: 300;
    }

    .login-body {
        padding: 40px 30px;
    }

    .form-group {
        margin-bottom: 25px;
        position: relative;
    }

    .form-control {
        height: 50px;
        border-radius: 10px;
        border: 2px solid #eee;
        padding-left: 20px;
        font-size: 1rem;
        transition: all 0.3s;
        background-color: #fdfdfd;
    }

    .form-control:focus {
        border-color:
            <?= $accent_color ?>
        ;
        box-shadow: 0 0 0 4px rgba(250, 174, 43, 0.1);
        background-color: #fff;
    }

    .form-label {
        font-weight: 600;
        font-size: 0.9rem;
        color:
            <?= $primary_color ?>
        ;
        margin-bottom: 8px;
        display: block;
    }

    .btn-login {
        background: linear-gradient(135deg,
                <?= $primary_color ?>
                0%, #4e4640 100%);
        color: white;
        width: 100%;
        height: 50px;
        border-radius: 10px;
        font-weight: 600;
        letter-spacing: 1px;
        border: none;
        transition: all 0.3s;
        margin-top: 10px;
        box-shadow: 0 4px 15px rgba(100, 92, 85, 0.3);
    }

    .btn-login:hover {
        background: linear-gradient(135deg,
                <?= $accent_color ?>
                0%, #e59a1f 100%);
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(250, 174, 43, 0.4);
        color: white;
    }

    .alert-custom {
        border-radius: 10px;
        font-size: 0.9rem;
        border: none;
    }

    .input-icon {
        position: absolute;
        right: 15px;
        top: 45px;
        color: #aaa;
    }
</style>

<div class="container login-container">
    <div class="login-card">
        <div class="login-header">
            <h2>Portal Admin</h2>
            <p>Silakan login untuk mengelola konten</p>
        </div>

        <div class="login-body">
            <!-- Flashdata Messages -->
            <?php if (session()->getFlashdata('error')): ?>
                <div class="alert alert-danger alert-custom mb-4" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?= session()->getFlashdata('error') ?>
                </div>
            <?php endif; ?>

            <?php if (session()->getFlashdata('success')): ?>
                <div class="alert alert-success alert-custom mb-4" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= session()->getFlashdata('success') ?>
                </div>
            <?php endif; ?>

            <form action="<?= base_url('admin/auth') ?>" method="post">
                <?= csrf_field() ?>

                <div class="form-group">
                    <label for="email" class="form-label">Username / Email</label>
                    <input type="text" name="email" class="form-control" id="email" placeholder="Masukkan username anda"
                        required autofocus value="<?= old('email') ?>">
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group">
                        <input type="password" name="password" class="form-control" id="password"
                            placeholder="Masukkan password anda" required
                            style="border-right: none; border-top-right-radius: 0; border-bottom-right-radius: 0;">
                        <span class="input-group-text bg-white"
                            style="border-left: none; border-top-left-radius: 0; border-bottom-left-radius: 0; border: 2px solid #eee; border-left: 0; cursor: pointer;"
                            onclick="togglePassword()">
                            <i class="fas fa-eye" id="toggleIcon" style="color: #aaa;"></i>
                        </span>
                    </div>
                </div>

                <button type="submit" class="btn btn-login">
                    MASUK SEKARANG <i class="fas fa-arrow-right ms-2" style="margin-left:8px;"></i>
                </button>
            </form>

            <div class="text-center mt-4">
                <a href="<?= base_url('/') ?>" style="text-decoration: none; color: #999; font-size: 0.9rem;">
                    <i class="fas fa-arrow-left me-1"></i> Kembali ke Beranda
                </a>
            </div>
        </div>
    </div>
</div>

<script>
    function togglePassword() {
        const passwordInput = document.getElementById('password');
        const toggleIcon = document.getElementById('toggleIcon');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            toggleIcon.classList.remove('fa-eye');
            toggleIcon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            toggleIcon.classList.remove('fa-eye-slash');
            toggleIcon.classList.add('fa-eye');
        }
    }
</script>

<!-- jQuery and Bootstrap JS -->
<script src="<?= base_url('js/jquery.min.js') ?>"></script>
<script src="<?= base_url('js/bootstrap.min.js') ?>"></script>

</body>
</html>