<?php
// Warna tema admin
$color_d = '#00473e';   // Hijau tua
$color_h = '#faae2b';   // Kuning oranye
$color_c = '#ffa8ba';   // Pink muda
$color_h_hover = '#d49525';

// Mode edit atau create
$is_edit    = isset($pegawai['id']);
$form_title = $is_edit ? 'Edit Data Pegawai: ' . ($pegawai['nama_pegawai'] ?? '') : 'Tambah Pegawai Baru';
?>

<?= $this->extend('layout/admin/admin_layout') ?>
<?= $this->section('content') ?>

<style>
    .admin-title { color: <?= $color_d ?>; font-weight: 700; margin-bottom: 30px; border-bottom: 3px solid <?= $color_h ?>; padding-bottom: 10px; }
    .admin-title .fas { color: <?= $color_h ?>; }
    .form-group label { color: <?= $color_d ?>; font-weight: 600; margin-bottom: 8px; }
    .form-control:focus { border-color: <?= $color_c ?>; box-shadow: 0 0 0 0.2rem rgba(255,168,186,0.25); }
    .btn-publish { background-color: <?= $color_h ?>; border-color: <?= $color_h ?>; color: <?= $color_d ?>; font-weight: bold; }
    .btn-publish:hover { background-color: <?= $color_h_hover ?>; border-color: <?= $color_h_hover ?>; color: <?= $color_d ?>; }
    .btn-draft { background-color: #a8a8a8; border-color: #a8a8a8; color: white; font-weight: 600; }
    .btn-draft:hover { background-color: #8f8f8f; border-color: #8f8f8f; }
</style>

<div class="container-fluid py-4">
    <h2 class="admin-title">
        <i class="fas <?= $is_edit ? 'fa-edit' : 'fa-user-plus' ?>"></i> <?= $form_title ?>
    </h2>

    <!-- Validasi Error -->
    <?php if (isset($validation)): ?>
        <div class="alert alert-danger">
            <h4 class="alert-heading">Validasi!</h4>
            <?= $validation->listErrors() ?>
        </div>
    <?php endif; ?>

    <form action="<?= base_url('admin/pegawai/save') ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>
        <input type="hidden" name="id" value="<?= $pegawai['id'] ?? '' ?>">

        <!-- Nama Pegawai (sesuai kolom di DB: nama_pegawai) -->
        <div class="form-group mb-3">
            <label for="nama_pegawai">Nama Pegawai <span class="text-danger">*</span></label>
            <input type="text" name="nama_pegawai" class="form-control" 
                   placeholder="Masukkan nama lengkap pegawai" 
                   value="<?= old('nama_pegawai', $pegawai['nama_pegawai'] ?? '') ?>" required>
        </div>

        <div class="row">
            <!-- Tanggal Lahir -->
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="tanggal_lahir">Tanggal Lahir</label>
                    <input type="date" name="tanggal_lahir" class="form-control"
                           value="<?= old('tanggal_lahir', $pegawai['tanggal_lahir'] ?? '') ?>">
                </div>
            </div>

            <!-- Jenis Kelamin -->
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="jenis_kelamin">Jenis Kelamin</label>
                    <select name="jenis_kelamin" class="form-control">
                        <?php $jk = old('jenis_kelamin', $pegawai['jenis_kelamin'] ?? 'laki-laki'); ?>
                        <option value="laki-laki" <?= $jk === 'laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                        <option value="perempuan" <?= $jk === 'perempuan' ? 'selected' : '' ?>>Perempuan</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Foto Pegawai -->
        <div class="form-group mb-4">
            <label for="foto_pegawai">Foto Pegawai (Max 1MB, JPG/PNG)</label>
            <input type="file" name="foto_pegawai" class="form-control-file" accept="image/jpeg,image/png">
            <?php if ($is_edit && !empty($pegawai['foto_pegawai'])): ?>
                <small class="text-muted">Foto saat ini: <?= $pegawai['foto_pegawai'] ?></small>
            <?php endif; ?>
        </div>

        <div class="form-group text-right">
            <a href="<?= base_url('admin/pegawai') ?>" class="btn btn-secondary mr-2">
                Kembali ke Daftar
            </a>

            <!-- Simpan Sebagai Draft -->
            <button type="submit" name="save_action" value="draft" class="btn btn-draft mr-2">
                Simpan Sebagai Draft
            </button>

            <!-- Simpan & Aktifkan -->
            <button type="submit" name="save_action" value="publish" class="btn btn-publish">
                Simpan & Aktifkan
            </button>
        </div>
    </form>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<?= $this->endSection() ?>