<?php
// Shared Color Palette
$color_d = '#645c55';   // Dark Brown
$color_h = '#faae2b';   // Highlight Orange
$color_c = '#e3ddd5';   // Beige
$color_bg = '#f2f7f5';  // Page Background
$color_text = '#475d5b'; // Text
?>

<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>

<style>
    body {
        background-color:
            <?= $color_bg ?>
        ;
    }

    .activity-hero {
        background: linear-gradient(135deg,
                <?= $color_c ?>
                0%, #e8e0d5 100%);
        padding: 60px 0 80px 0;
        text-align: center;
        border-bottom-left-radius: 50% 20px;
        border-bottom-right-radius: 50% 20px;
        margin-bottom: 40px;
    }

    .activity-hero h1 {
        font-family: 'Playfair Display', serif;
        font-weight: 700;
        font-size: 2.5rem;
        color:
            <?= $color_d ?>
        ;
        margin-bottom: 10px;
    }

    .activity-hero p {
        font-family: 'Montserrat', sans-serif;
        color:
            <?= $color_text ?>
        ;
        letter-spacing: 1px;
    }

    /* Card Style for Activities */
    .activity-card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-left: 5px solid
            <?= $color_h ?>
        ;
        margin-bottom: 20px;
        position: relative;
        overflow: hidden;
    }

    .activity-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.08);
    }

    .time-badge {
        background:
            <?= $color_h ?>
        ;
        color: white;
        padding: 5px 15px;
        border-radius: 20px;
        font-family: 'Montserrat', sans-serif;
        font-weight: 600;
        font-size: 0.85rem;
        display: inline-block;
        margin-bottom: 15px;
        box-shadow: 0 5px 15px rgba(250, 174, 43, 0.3);
    }

    .activity-date {
        font-family: 'Montserrat', sans-serif;
        font-size: 0.9rem;
        color:
            <?= $color_text ?>
        ;
        opacity: 0.8;
        float: right;
        margin-top: 5px;
    }

    .activity-title {
        font-family: 'Playfair Display', serif;
        font-size: 1.5rem;
        color:
            <?= $color_d ?>
        ;
        margin-bottom: 10px;
        font-weight: 700;
    }

    .activity-desc {
        font-family: 'Montserrat', sans-serif;
        color:
            <?= $color_text ?>
        ;
        font-size: 0.95rem;
    }

    .day-label {
        position: absolute;
        top: 20px;
        right: -30px;
        background:
            <?= $color_d ?>
        ;
        color:
            <?= $color_c ?>
        ;
        width: 120px;
        text-align: center;
        padding: 5px 0;
        transform: rotate(45deg);
        font-family: 'Montserrat', sans-serif;
        font-size: 0.8rem;
        font-weight: 600;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }
</style>

<!-- Hero Section -->
<div class="activity-hero">
    <div class="container">
        <h1>Aktivitas Harian</h1>
        <p>Jadwal Kegiatan & Rutinitas</p>
    </div>
</div>

<!-- Search & Filter Section -->
<div class="container" style="margin-top: -30px; position: relative; z-index: 10; margin-bottom: 50px;">
    <div class="row justify-content-center">
        <div class="col-lg-9"> <!-- Slightly wider for date input -->
            <div class="p-3 bg-white shadow-sm" style="border-radius: 15px; border: 1px solid rgba(0,0,0,0.05);">
                <form action="" method="get">
                    <div class="row align-items-center g-2">

                        <!-- Search Input -->
                        <div class="col-md-5 mb-2 mb-md-0">
                            <input type="text" name="q" value="<?= esc($search) ?>"
                                class="form-control border-0 shadow-none" placeholder="Cari aktivitas..."
                                style="background: #f8f9fa; border-radius: 8px; font-size: 0.9rem; padding: 8px 12px;">
                        </div>

                        <!-- Date Filter -->
                        <div class="col-md-3 mb-2 mb-md-0">
                            <input type="date" name="date" value="<?= esc($date_filter) ?>"
                                class="form-control border-0 shadow-none"
                                style="background: #f8f9fa; border-radius: 8px; font-size: 0.9rem; padding: 8px 12px;">
                        </div>

                        <!-- Buttons -->
                        <div class="col-md-4 d-flex gap-2">
                            <button type="submit" class="btn w-100 font-weight-bold text-white btn-theme-main"
                                style="background-color: <?= $color_d ?>; border-radius: 8px; font-size: 0.9rem; padding: 6px 10px; box-shadow: 0 2px 5px rgba(100, 92, 85, 0.2);">
                                Cari
                            </button>
                            <a href="?" class="btn w-100 font-weight-bold text-white btn-theme-accent"
                                style="background-color: <?= $color_h ?>; border-radius: 8px; font-size: 0.9rem; padding: 6px 10px; box-shadow: 0 2px 5px rgba(250, 174, 43, 0.2);">
                                Reset
                            </a>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    /* Hover effects for buttons */
    .btn-theme-main:hover {
        background-color: #4e4640 !important;
        transform: translateY(-2px);
    }

    .btn-theme-accent:hover {
        background-color: #e59a1f !important;
        transform: translateY(-2px);
    }
</style>

<!-- Main Content -->
<div class="container pb-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <?php if (empty($activities)): ?>
                <div class="text-center py-5">
                    <i class="far fa-calendar-times mb-3" style="font-size: 3rem; color: #ddd;"></i>
                    <p style="color: <?= $color_text ?>; font-family: 'Montserrat', sans-serif;">Tidak ada aktivitas
                        ditemukan.</p>
                    <a href="?" class="btn btn-sm btn-outline-secondary" style="border-radius: 20px;">Lihat Semua</a>
                </div>
            <?php else: ?>

                <?php foreach ($activities as $act): ?>
                    <div class="activity-card">
                        <div class="day-label"><?= esc(strtoupper($act['day'])) ?></div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="time-badge"><i class="far fa-clock mr-2"></i><?= esc($act['time']) ?></span>
                            <span class="activity-date"><i class="far fa-calendar-alt mr-2"></i><?= esc($act['date']) ?></span>
                        </div>

                        <?php if (!empty($act['image'])): ?>
                            <div class="mb-3">
                                <img src="<?= base_url('uploads/activities/' . $act['image']) ?>" alt="<?= esc($act['name']) ?>"
                                    class="img-fluid w-100 shadow-sm"
                                    style="border-radius: 10px; height: 250px; object-fit: cover;">
                            </div>
                        <?php endif; ?>

                        <h3 class="activity-title"><?= esc($act['name']) ?></h3>
                        <p class="activity-desc"><?= esc($act['description']) ?></p>
                    </div>
                <?php endforeach; ?>

                <!-- Pagination Links -->
                <?php if ($totalPages >= 1): ?>
                    <div class="mt-5 d-flex justify-content-center">
                        <nav aria-label="Page navigation">
                            <ul class="pagination">
                                <!-- Prev -->
                                <?php if ($totalPages > 1): ?>
                                    <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                                        <a class="page-link"
                                            href="?q=<?= esc($search) ?>&date=<?= esc($date_filter) ?>&page=<?= $page - 1 ?>"
                                            aria-label="Previous">
                                            <span aria-hidden="true">&laquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <!-- Page Numbers -->
                                <?php for ($p = 1; $p <= $totalPages; $p++): ?>
                                    <li class="page-item <?= ($page == $p) ? 'active' : '' ?>">
                                        <a class="page-link"
                                            style="<?= ($page == $p) ? 'background-color: ' . $color_h . '; border-color: ' . $color_h . '; color: #fff;' : 'color: ' . $color_d . ';' ?>"
                                            href="?q=<?= esc($search) ?>&date=<?= esc($date_filter) ?>&page=<?= $p ?>"><?= $p ?></a>
                                    </li>
                                <?php endfor; ?>

                                <!-- Next -->
                                <?php if ($totalPages > 1): ?>
                                    <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
                                        <a class="page-link"
                                            href="?q=<?= esc($search) ?>&date=<?= esc($date_filter) ?>&page=<?= $page + 1 ?>"
                                            aria-label="Next">
                                            <span aria-hidden="true">&raquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                <?php endif; ?>

            <?php endif; ?>

        </div>
    </div>
</div>

<?= $this->endSection() ?>