<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class News extends Migration
{
    public function up()
    {
        // Membuat kolom/field untuk tabel news
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true
            ],
            'title' => [
                'type'           => 'VARCHAR',
                'constraint'     => '255'
            ],
            'author' => [
                'type'           => 'VARCHAR',
                'constraint'     => 100,
                'default'        => 'John Doe',
            ],
            'content' => [
                'type'           => 'TEXT',
                'null'           => true,
            ],
            'status' => [
                'type'           => 'ENUM',
                'constraint'     => ['published', 'draft'],
                'default'        => 'draft',
            ],
        ]);

        // Primary key
        $this->forge->addKey('id', true);

        // Membuat tabel news terlebih dahulu
        $this->forge->createTable('news', true);

        // Tambahkan kolom created_at secara manual (menghindari error default value)
        $this->db->query("
            ALTER TABLE `news`
            ADD `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
        ");
    }

    public function down()
    {
        // Hapus tabel news jika rollback
        $this->forge->dropTable('news', true);
    }
}