<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// ===================================
// PUBLIC ROUTES
// ===================================

// Home
$routes->get('/', 'Home::index');

// Halaman Statis
$routes->get('/biodata', 'Page::about');
$routes->get('/education', 'Page::education');
$routes->get('/contact', 'Page::education'); // Redirect old contact URL to education as well just in case
$routes->get('/aktivitas', 'Page::aktivitas');

// Daftar Pegawai (Menggunakan /news)
$routes->get('/news', 'News::index');

// Rute Detail Pegawai (FUNGSI detail ada di Controller News::viewPegawai)
// 1. Menangani pola URL: /news/slug-pegawai (URL yang bersih)
$routes->get('news/(:segment)', 'News::viewPegawai/$1');

// 2. Menangani pola URL yang Anda klik: /news/detail/slug-pegawai (URL yang bermasalah 404 sebelumnya)
$routes->get('news/detail/(:segment)', 'News::viewPegawai/$1');
// Rute Edit yang Benar (Sesuai dengan nama file view admin_edit_news.php)
// Pastikan rute ini ada dan diletakkan di atas rute '/admin/pegawai' statis lainnya (jika ada)

// ATAU jika Anda menggunakan Route Group
$routes->group('admin', function ($routes) {
    // ... rute admin lainnya ...
    $routes->get('pegawai/edit/(:segment)', 'PegawaiAdmin::edit/$1');
    // Ganti 'PegawaiController::edit' dengan nama Controller dan fungsi Anda yang sebenarnya.
});

// Catatan: Placeholder ':segment' menangkap karakter non-slash. 
// Jika Anda ingin lebih aman, gunakan '(:any)' tetapi ini kurang direkomendasikan.

// ===================================
// ADMIN & AUTHENTICATION ROUTES
// ===================================

// Authentication (Login/Logout)
$routes->get('admin/login', 'AuthController::login');
$routes->post('admin/auth', 'AuthController::attemptLogin');
$routes->get('admin/logout', 'AuthController::logout');

// Grup Admin (Membutuhkan Filter 'auth')
$routes->group('admin', ['filter' => 'auth'], function ($routes) {

    // Dashboard
    $routes->get('dashboard', 'AdminController::index');
    $routes->get('/', 'AdminController::index'); // Redirect /admin to /admin/dashboard

    // --- Activities CRUD ---
    $routes->get('activities', 'AdminActivities::index');
    $routes->get('activities/create', 'AdminActivities::create');
    $routes->post('activities/store', 'AdminActivities::store');
    $routes->get('activities/edit/(:num)', 'AdminActivities::edit/$1');
    $routes->post('activities/update/(:num)', 'AdminActivities::update/$1');
    $routes->get('activities/delete/(:num)', 'AdminActivities::delete/$1');

    // --- Education CRUD ---
    $routes->get('education', 'AdminEducation::index');
    $routes->get('education/create', 'AdminEducation::create');
    $routes->post('education/store', 'AdminEducation::store');
    $routes->get('education/edit/(:num)', 'AdminEducation::edit/$1');
    $routes->post('education/update/(:num)', 'AdminEducation::update/$1');
    $routes->get('education/delete/(:num)', 'AdminEducation::delete/$1');

    // --- Biodata CRUD ---
    $routes->get('biodata', 'AdminBiodata::index');
    $routes->get('biodata/create', 'AdminBiodata::create');
    $routes->post('biodata/store', 'AdminBiodata::store');
    $routes->get('biodata/edit/(:num)', 'AdminBiodata::edit/$1'); // Generally only one biodata, but allow edit by ID or singleton
    $routes->post('biodata/update/(:num)', 'AdminBiodata::update/$1');
    $routes->get('biodata/delete/(:num)', 'AdminBiodata::delete/$1');
    // If we assume only 1 biodata record, we might route to a singleton controller method, but standard CRUD is fine.
});