<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Produk - Sistem Manajemen Gudang</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background: #f4f6fa; }
        .sidebar {
            min-height: 100vh;
            background: #2563eb;
            color: #fff;
            padding: 32px 18px 18px 18px;
        }
        .sidebar .nav-link {
            color: #fff;
            font-weight: 500;
            margin-bottom: 12px;
            border-radius: 8px;
            transition: background 0.2s;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            background: #1e40af;
            color: #fff;
        }
        .main-content {
            padding: 32px 24px;
        }
        .form-card {
            border-radius: 16px;
            box-shadow: 0 2px 12px rgba(31,38,135,0.08);
            background: #fff;
            padding: 24px;
        }
        .produk-preview {
            max-width: 200px;
            max-height: 200px;
            object-fit: cover;
            border-radius: 8px;
            border: 2px solid #e2e8f0;
        }
        @media (max-width: 768px) {
            .sidebar { min-height: auto; padding: 16px 8px; }
            .main-content { padding: 16px 4px; }
            .form-card { padding: 8px; }
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block sidebar">
            <div class="position-sticky">
                <h4 class="mb-4 fw-bold">Menu</h4>
                <ul class="nav flex-column">
                    <li class="nav-item"><a href="<?php echo e(route('dashboard')); ?>" class="nav-link"><i class="fa fa-home me-2"></i>Dashboard</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('produk.index')); ?>" class="nav-link active"><i class="fa fa-box me-2"></i>Manajemen Produk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.masuk')); ?>" class="nav-link"><i class="fa fa-arrow-down me-2"></i>Barang Masuk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.keluar')); ?>" class="nav-link"><i class="fa fa-arrow-up me-2"></i>Barang Keluar</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('riwayat.transaksi')); ?>" class="nav-link"><i class="fa fa-history me-2"></i>Riwayat Transaksi</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('laporan')); ?>" class="nav-link"><i class="fa fa-file-alt me-2"></i>Laporan & Export</a></li>
                </ul>
                
                <!-- Logout Button -->
                <div class="mt-4 pt-3 border-top">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-light w-100">
                            <i class="fa fa-sign-out-alt me-2"></i>Logout
                        </button>
                    </form>
                </div>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 main-content">
            <div class="form-card">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="fw-bold mb-0">
                        <i class="fa fa-edit me-2"></i>Edit Produk
                    </h3>
                    <a href="<?php echo e(route('produk.index')); ?>" class="btn btn-secondary">
                        <i class="fa fa-arrow-left me-2"></i>Kembali
                    </a>
                </div>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('produk.update', $produk->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="nama" class="form-label">Nama Produk <span class="text-danger">*</span></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['nama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="nama" name="nama" value="<?php echo e(old('nama', $produk->nama)); ?>" 
                                       placeholder="Masukkan nama produk" required>
                                <?php $__errorArgs = ['nama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="mb-3">
                                <label for="stok" class="form-label">Stok <span class="text-danger">*</span></label>
                                <input type="number" class="form-control <?php $__errorArgs = ['stok'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="stok" name="stok" value="<?php echo e(old('stok', $produk->stok)); ?>" 
                                       placeholder="Masukkan jumlah stok" required min="0">
                                <?php $__errorArgs = ['stok'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="mb-3">
                                <label for="foto" class="form-label">Foto Produk</label>
                                <input type="file" class="form-control <?php $__errorArgs = ['foto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="foto" name="foto" accept="image/*">
                                <div class="form-text">Format: JPG, JPEG, PNG. Maksimal 2MB. Kosongkan jika tidak ingin mengubah foto.</div>
                                <?php $__errorArgs = ['foto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">
                                        <i class="fa fa-image me-2"></i>Foto Saat Ini
                                    </h6>
                                </div>
                                <div class="card-body text-center">
                                    <?php if($produk->foto): ?>
                                        <img src="<?php echo e(asset('storage/' . $produk->foto)); ?>" 
                                             class="produk-preview mb-2" alt="Foto Produk">
                                        <p class="text-muted small"><?php echo e($produk->nama); ?></p>
                                    <?php else: ?>
                                        <div class="text-muted">
                                            <i class="fa fa-image fa-3x mb-2"></i>
                                            <p>Tidak ada foto</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="card mt-3">
                                <div class="card-header">
                                    <h6 class="mb-0">
                                        <i class="fa fa-info-circle me-2"></i>Informasi
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="alert alert-info">
                                        <h6><i class="fa fa-lightbulb me-2"></i>Petunjuk:</h6>
                                        <ul class="mb-0">
                                            <li>Nama produk harus unik</li>
                                            <li>Stok tidak boleh negatif</li>
                                            <li>Foto bersifat opsional</li>
                                            <li>Foto lama akan diganti</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-end gap-2">
                        <a href="<?php echo e(route('produk.index')); ?>" class="btn btn-secondary">
                            <i class="fa fa-times me-2"></i>Batal
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save me-2"></i>Update Produk
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> <?php /**PATH C:\xampp2\htdocs\management_gudang\resources\views/produk/edit.blade.php ENDPATH**/ ?>