<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Produk;

class ProdukSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $produks = [
            [
                'nama' => 'Laptop Asus ROG',
                'stok' => 10,
                'foto' => null,
            ],
            [
                'nama' => 'Mouse Gaming',
                'stok' => 25,
                'foto' => null,
            ],
            [
                'nama' => 'Keyboard Mechanical',
                'stok' => 15,
                'foto' => null,
            ],
            [
                'nama' => 'Monitor 24 inch',
                'stok' => 8,
                'foto' => null,
            ],
            [
                'nama' => 'Headphone Wireless',
                'stok' => 20,
                'foto' => null,
            ],
            [
                'nama' => 'SSD 500GB',
                'stok' => 30,
                'foto' => null,
            ],
            [
                'nama' => 'RAM DDR4 8GB',
                'stok' => 40,
                'foto' => null,
            ],
            [
                'nama' => 'Power Supply 550W',
                'stok' => 12,
                'foto' => null,
            ],
        ];

        foreach ($produks as $produk) {
            Produk::create($produk);
        }
    }
}
