<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('transaksis', function (Blueprint $table) {
            // Drop kolom lama
            $table->dropColumn(['harga_satuan', 'total_harga', 'supplier']);
            
            // Tambah kolom baru
            $table->date('tanggal')->after('jumlah');
            $table->string('nama_bagian')->nullable()->after('keterangan'); // untuk barang masuk
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('transaksis', function (Blueprint $table) {
            // Hapus kolom baru
            $table->dropColumn(['tanggal', 'nama_bagian']);
            
            // Kembalikan kolom lama
            $table->decimal('harga_satuan', 10, 2)->nullable()->after('jumlah');
            $table->decimal('total_harga', 10, 2)->nullable()->after('harga_satuan');
            $table->string('supplier')->nullable()->after('keterangan');
        });
    }
};
