<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Transaksi - Sistem Manajemen Gudang</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #f4f6fa; }
        .sidebar {
            min-height: 100vh;
            background: #2563eb;
            color: #fff;
            padding: 32px 18px 18px 18px;
        }
        .sidebar .nav-link {
            color: #fff;
            font-weight: 500;
            margin-bottom: 12px;
            border-radius: 8px;
            transition: background 0.2s;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            background: #1e40af;
            color: #fff;
        }
        .main-content {
            padding: 32px 24px;
        }
        .table-card {
            border-radius: 16px;
            box-shadow: 0 2px 12px rgba(31,38,135,0.08);
            background: #fff;
            padding: 24px;
        }
        .logo-sekai {
            max-width: 120px;
            height: auto;
            margin-bottom: 1rem;
        }
        .company-name {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        .system-name {
            font-size: 0.8rem;
            opacity: 0.8;
            margin-bottom: 1rem;
        }
        @media (max-width: 768px) {
            .sidebar { min-height: auto; padding: 16px 8px; }
            .main-content { padding: 16px 4px; }
            .table-card { padding: 8px; }
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block sidebar">
            <div class="position-sticky">
                <!-- Logo Section -->
                <div class="text-center mb-4">
                    <img src="<?php echo e(asset('images/logo-sekai.png')); ?>" alt="Logo Sekai" class="logo-sekai">
                    <div class="company-name">SEKAI</div>
                    <div class="system-name">Warehouse Management</div>
                </div>
                
                <h4 class="mb-4 fw-bold">Menu</h4>
                <ul class="nav flex-column">
                    <li class="nav-item"><a href="<?php echo e(route('dashboard')); ?>" class="nav-link"><i class="fa fa-home me-2"></i>Dashboard</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('produk.index')); ?>" class="nav-link"><i class="fa fa-box me-2"></i>Manajemen Produk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.masuk')); ?>" class="nav-link"><i class="fa fa-arrow-down me-2"></i>Barang Masuk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.keluar')); ?>" class="nav-link"><i class="fa fa-arrow-up me-2"></i>Barang Keluar</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('riwayat.transaksi')); ?>" class="nav-link active"><i class="fa fa-history me-2"></i>Riwayat Transaksi</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('laporan')); ?>" class="nav-link"><i class="fa fa-file-alt me-2"></i>Laporan & Export</a></li>
                </ul>
                
                <!-- Logout Button -->
                <div class="mt-4 pt-3 border-top">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-light w-100">
                            <i class="fa fa-sign-out-alt me-2"></i>Logout
                        </button>
                    </form>
                </div>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 main-content">
            <div class="table-card">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="fw-bold mb-0">
                        <i class="fas fa-history me-2"></i>Riwayat Transaksi
                    </h3>
                </div>
                
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>Kode Transaksi</th>
                                <th>Tanggal</th>
                                <th>Jenis</th>
                                <th>Produk</th>
                                <th>Jumlah</th>
                                <th>Nama Bagian</th>
                                <th>User</th>
                                <th>Keterangan</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transaksis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaksi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <span class="badge bg-primary"><?php echo e($transaksi->kode_transaksi); ?></span>
                                    </td>
                                    <td><?php echo e($transaksi->tanggal->format('d/m/Y')); ?></td>
                                    <td>
                                        <?php if($transaksi->jenis === 'masuk'): ?>
                                            <span class="badge bg-success">
                                                <i class="fas fa-arrow-down me-1"></i>Masuk
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">
                                                <i class="fas fa-arrow-up me-1"></i>Keluar
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($transaksi->produk->nama); ?></td>
                                    <td><?php echo e($transaksi->jumlah); ?></td>
                                    <td><?php echo e($transaksi->nama_bagian ?: '-'); ?></td>
                                    <td><?php echo e($transaksi->user->name); ?></td>
                                    <td><?php echo e($transaksi->keterangan ?: '-'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">
                                        <i class="fa fa-inbox fa-3x mb-3"></i>
                                        <p>Belum ada data transaksi.</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if($transaksis->hasPages()): ?>
                    <div class="d-flex justify-content-center">
                        <?php echo e($transaksis->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> <?php /**PATH C:\xampp2\htdocs\management_gudang\resources\views/riwayat_transaksi.blade.php ENDPATH**/ ?>