<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaksi extends Model
{
    use HasFactory;

    protected $fillable = [
        'kode_transaksi',
        'jenis',
        'produk_id',
        'jumlah',
        'tanggal',
        'keterangan',
        'nama_bagian',
        'user_id'
    ];

    protected $casts = [
        'tanggal' => 'date',
    ];

    public function produk()
    {
        return $this->belongsTo(Produk::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopeBarangMasuk($query)
    {
        return $query->where('jenis', 'masuk');
    }

    public function scopeBarangKeluar($query)
    {
        return $query->where('jenis', 'keluar');
    }

    public static function generateKodeTransaksi($jenis)
    {
        $prefix = $jenis === 'masuk' ? 'BM' : 'BK';
        $date = now()->format('Ymd');
        
        $lastTransaksi = self::where('kode_transaksi', 'like', $prefix . $date . '%')
            ->orderBy('kode_transaksi', 'desc')
            ->first();
        
        if ($lastTransaksi) {
            $lastNumber = intval(substr($lastTransaksi->kode_transaksi, -4));
            $newNumber = $lastNumber + 1;
        } else {
            $newNumber = 1;
        }
        
        return $prefix . $date . str_pad($newNumber, 4, '0', STR_PAD_LEFT);
    }
} 