<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Produk extends Model
{
    use HasFactory;

    protected $fillable = [
        'nama',
        'stok',
        'foto'
    ];

    // Relasi dengan Transaksi
    public function transaksis()
    {
        return $this->hasMany(Transaksi::class);
    }

    // Update stok berdasarkan transaksi
    public function updateStok($jumlah, $jenis)
    {
        if ($jenis === 'masuk') {
            $this->stok += $jumlah;
        } else {
            $this->stok -= $jumlah;
        }
        $this->save();
    }

    // Cek apakah stok mencukupi untuk barang keluar
    public function stokCukup($jumlah)
    {
        return $this->stok >= $jumlah;
    }
}
