<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan & Export - Sistem Manajemen Gudang</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body { background: #f4f6fa; }
        .sidebar {
            min-height: 100vh;
            background: #2563eb;
            color: #fff;
            padding: 32px 18px 18px 18px;
        }
        .sidebar .nav-link {
            color: #fff;
            font-weight: 500;
            margin-bottom: 12px;
            border-radius: 8px;
            transition: background 0.2s;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            background: #1e40af;
            color: #fff;
        }
        .main-content {
            padding: 32px 24px;
        }
        .report-card {
            border-radius: 16px;
            box-shadow: 0 2px 12px rgba(31,38,135,0.08);
            background: #fff;
            padding: 24px;
            margin-bottom: 24px;
        }
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 16px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .stats-card.success {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }
        .stats-card.warning {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }
        .stats-card.danger {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        }
        @media (max-width: 768px) {
            .sidebar { min-height: auto; padding: 16px 8px; }
            .main-content { padding: 16px 4px; }
            .report-card { padding: 8px; }
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block sidebar">
            <div class="position-sticky">
                <h4 class="mb-4 fw-bold">Menu</h4>
                <ul class="nav flex-column">
                    <li class="nav-item"><a href="<?php echo e(route('dashboard')); ?>" class="nav-link"><i class="fa fa-home me-2"></i>Dashboard</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('produk.index')); ?>" class="nav-link"><i class="fa fa-box me-2"></i>Manajemen Produk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.masuk')); ?>" class="nav-link"><i class="fa fa-arrow-down me-2"></i>Barang Masuk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.keluar')); ?>" class="nav-link"><i class="fa fa-arrow-up me-2"></i>Barang Keluar</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('riwayat.transaksi')); ?>" class="nav-link"><i class="fa fa-history me-2"></i>Riwayat Transaksi</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('laporan')); ?>" class="nav-link active"><i class="fa fa-file-alt me-2"></i>Laporan & Export</a></li>
                </ul>
                
                <!-- Logout Button -->
                <div class="mt-4 pt-3 border-top">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-light w-100">
                            <i class="fa fa-sign-out-alt me-2"></i>Logout
                        </button>
                    </form>
                </div>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 main-content">
            <?php if(session('info')): ?>
                <div class="alert alert-info alert-dismissible fade show" role="alert">
                    <?php echo e(session('info')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Header -->
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Laporan & Export</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <a href="<?php echo e(route('laporan.exportPdf')); ?>" class="btn btn-danger">
                            <i class="fa fa-file-pdf me-2"></i>Export PDF
                        </a>
                        <a href="<?php echo e(route('laporan.exportExcel')); ?>" class="btn btn-success">
                            <i class="fa fa-file-excel me-2"></i>Export Excel
                        </a>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="stats-card">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="mb-0"><?php echo e($totalProduk); ?></h4>
                                <p class="mb-0">Total Produk</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fa fa-box fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card success">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="mb-0"><?php echo e($totalStok); ?></h4>
                                <p class="mb-0">Total Stok</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fa fa-warehouse fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card warning">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="mb-0"><?php echo e($totalTransaksi); ?></h4>
                                <p class="mb-0">Total Transaksi</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fa fa-exchange-alt fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Stok menipis count hidden from laporan as requested -->
            </div>

            <!-- Chart -->
            <div class="report-card">
                <h4 class="mb-3">
                    <i class="fa fa-chart-line me-2"></i>Grafik Transaksi Bulanan
                </h4>
                <canvas id="transaksiChart" width="400" height="200"></canvas>
        </div>

            <!-- Produk dengan stok terendah disembunyikan sesuai permintaan -->

            <!-- Transaksi Terbaru -->
            <div class="report-card">
                <h4 class="mb-3">
                    <i class="fa fa-history me-2"></i>Transaksi Terbaru
                </h4>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-dark">
                                                            <tr>
                                    <th>Kode</th>
                                    <th>Tanggal</th>
                    <th>Jenis</th>
                                    <th>Produk</th>
                    <th>Jumlah</th>
                                    <th>Nama Bagian</th>
                                    <th>User</th>
                </tr>
            </thead>
            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transaksiTerbaru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaksi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <span class="badge bg-primary"><?php echo e($transaksi->kode_transaksi); ?></span>
                                    </td>
                                    <td><?php echo e($transaksi->tanggal->format('d/m/Y')); ?></td>
                                    <td>
                                        <?php if($transaksi->jenis === 'masuk'): ?>
                                            <span class="badge bg-success">
                                                <i class="fa fa-arrow-down me-1"></i>Masuk
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">
                                                <i class="fa fa-arrow-up me-1"></i>Keluar
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($transaksi->produk->nama); ?></td>
                                    <td><?php echo e($transaksi->jumlah); ?></td>
                                    <td><?php echo e($transaksi->nama_bagian ?: '-'); ?></td>
                                    <td><?php echo e($transaksi->user->name); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center text-muted">
                                        <i class="fa fa-inbox fa-3x mb-3"></i>
                                        <p>Belum ada data transaksi.</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
            </tbody>
        </table>
                </div>
            </div>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Chart.js untuk grafik transaksi
const ctx = document.getElementById('transaksiChart').getContext('2d');
const transaksiChart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode(array_keys($transaksiBulanan), 15, 512) ?>,
        datasets: [{
            label: 'Jumlah Transaksi',
            data: <?php echo json_encode(array_values($transaksiBulanan), 15, 512) ?>,
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
</body>
</html> <?php /**PATH C:\xampp2\htdocs\management_gudang\resources\views/laporan.blade.php ENDPATH**/ ?>