<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Management Gudang</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background: #f4f6fa; }
        .sidebar {
            min-height: 100vh;
            background: #2563eb;
            color: #fff;
            padding: 32px 18px 18px 18px;
        }
        .sidebar .nav-link {
            color: #fff;
            font-weight: 500;
            margin-bottom: 12px;
            border-radius: 8px;
            transition: background 0.2s;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            background: #1e40af;
            color: #fff;
        }
        .main-content {
            padding: 32px 24px;
        }
        .table-card {
            border-radius: 16px;
            box-shadow: 0 2px 12px rgba(31,38,135,0.08);
            background: #fff;
            padding: 24px;
        }
        .search-bar {
            margin-bottom: 18px;
        }
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 16px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .stats-card.linkable {
            cursor: pointer;
            transition: transform .12s ease, box-shadow .12s ease;
        }
        .stats-card.linkable:hover {
            transform: translateY(-4px);
            box-shadow: 0 6px 18px rgba(0,0,0,0.12);
        }
        .stats-card.success {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }
        .stats-card.warning {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }
        .stats-card.danger {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        }
        .logo-sekai {
            max-width: 120px;
            height: auto;
            margin-bottom: 1rem;
        }
        .company-name {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        .system-name {
            font-size: 0.8rem;
            opacity: 0.8;
            margin-bottom: 1rem;
        }
        @media (max-width: 768px) {
            .sidebar { min-height: auto; padding: 16px 8px; }
            .main-content { padding: 16px 4px; }
            .table-card { padding: 8px; }
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block sidebar">
            <div class="position-sticky">
                <!-- Logo Section -->
                <div class="text-center mb-4">
                    <img src="<?php echo e(asset('images/logo-sekai.png')); ?>" alt="Logo Sekai" class="logo-sekai">
                    <div class="company-name">SEKAI</div>
                    <div class="system-name">Warehouse Management</div>
                </div>
                
                <h4 class="mb-4 fw-bold">Menu</h4>
                <ul class="nav flex-column">
                    <li class="nav-item"><a href="/dashboard" class="nav-link active"><i class="fa fa-home me-2"></i>Dashboard</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('produk.index')); ?>" class="nav-link"><i class="fa fa-box me-2"></i>Manajemen Produk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.masuk')); ?>" class="nav-link"><i class="fa fa-arrow-down me-2"></i>Barang Masuk</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('barang.keluar')); ?>" class="nav-link"><i class="fa fa-arrow-up me-2"></i>Barang Keluar</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('riwayat.transaksi')); ?>" class="nav-link"><i class="fa fa-history me-2"></i>Riwayat Transaksi</a></li>
                    <li class="nav-item"><a href="<?php echo e(route('laporan')); ?>" class="nav-link"><i class="fa fa-file-alt me-2"></i>Laporan & Export</a></li>
                </ul>
                
                <!-- Logout Button -->
                <div class="mt-4 pt-3 border-top">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-light w-100">
                            <i class="fa fa-sign-out-alt me-2"></i>Logout
                        </button>
                    </form>
                </div>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 main-content">
            <!-- Welcome Message -->
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <span class="text-muted">Selamat datang, <?php echo e(auth()->user()->name); ?>!</span>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="stats-card">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="mb-0"><?php echo e($totalProduk); ?></h4>
                                <p class="mb-0">Total Produk</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fa fa-box fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card success">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="mb-0"><?php echo e($totalStok); ?></h4>
                                <p class="mb-0">Total Stok</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fa fa-warehouse fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <a href="<?php echo e(route('riwayat.transaksi')); ?>" class="stats-card warning linkable text-white text-decoration-none d-block" role="button">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="mb-0"><?php echo e($transaksiHariIni); ?></h4>
                                <p class="mb-0">Transaksi Hari Ini</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fa fa-exchange-alt fa-2x"></i>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3">
                    <a href="<?php echo e(route('produk.index', ['max_stok' => 5])); ?>" class="stats-card danger text-white text-decoration-none d-block">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="mb-0"><?php echo e($produkStokMenipis); ?></h4>
                                <p class="mb-0">Stok Menipis</p>
                            </div>
                            <div class="align-self-center">
                                <i class="fa fa-exclamation-triangle fa-2x"></i>
                            </div>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Products Table -->
            <div class="table-card">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="fw-bold mb-0">Stok Produk</h3>
                    <a href="<?php echo e(route('produk.create')); ?>" class="btn btn-primary">
                        <i class="fa fa-plus me-2"></i>Tambah Produk
                    </a>
                </div>
                
                <!-- Filter/Pencarian -->
                <form class="row g-2 align-items-center search-bar" method="GET" action="">
                    <div class="col-auto">
                        <input type="text" class="form-control" name="q" placeholder="Cari produk..." value="<?php echo e(request('q')); ?>">
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i> Cari</button>
                    </div>
                </form>
                
                <!-- Tabel Produk -->
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>Nama Produk</th>
                                <th>Stok</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $produks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($produk->nama); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($produk->stok > 10 ? 'success' : ($produk->stok > 5 ? 'warning' : 'danger')); ?>">
                                            <?php echo e($produk->stok); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($produk->stok > 10): ?>
                                            <span class="badge bg-success">Tersedia</span>
                                        <?php elseif($produk->stok > 5): ?>
                                            <span class="badge bg-warning">Stok Menipis</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Hampir Habis</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('produk.edit', $produk->id)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <a href="<?php echo e(route('produk.show', $produk->id)); ?>" class="btn btn-sm btn-outline-info">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted">
                                        <i class="fa fa-inbox fa-3x mb-3"></i>
                                        <p>Belum ada data produk.</p>
                                        <a href="<?php echo e(route('produk.create')); ?>" class="btn btn-primary">
                                            <i class="fa fa-plus me-2"></i>Tambah Produk Pertama
                                        </a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
</div>
</body>
</html> <?php /**PATH C:\xampp2\htdocs\management_gudang\resources\views/dashboard.blade.php ENDPATH**/ ?>