<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Produk - Sistem Manajemen Gudang</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background: #f4f6fa; }
        .sidebar {
            min-height: 100vh;
            background: #2563eb;
            color: #fff;
            padding: 32px 18px 18px 18px;
        }
        .sidebar .nav-link {
            color: #fff;
            font-weight: 500;
            margin-bottom: 12px;
            border-radius: 8px;
            transition: background 0.2s;
        }
        .sidebar .nav-link.active, .sidebar .nav-link:hover {
            background: #1e40af;
            color: #fff;
        }
        .main-content {
            padding: 32px 24px;
        }
        .detail-card {
            border-radius: 16px;
            box-shadow: 0 2px 12px rgba(31,38,135,0.08);
            background: #fff;
            padding: 24px;
        }
        .produk-image {
            max-width: 300px;
            max-height: 300px;
            object-fit: cover;
            border-radius: 12px;
            border: 3px solid #e2e8f0;
        }
        .status-badge {
            font-size: 0.9rem;
            padding: 8px 16px;
        }
        @media (max-width: 768px) {
            .sidebar { min-height: auto; padding: 16px 8px; }
            .main-content { padding: 16px 4px; }
            .detail-card { padding: 8px; }
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block sidebar">
            <div class="position-sticky">
                <h4 class="mb-4 fw-bold">Menu</h4>
                <ul class="nav flex-column">
                    <li class="nav-item"><a href="{{ route('dashboard') }}" class="nav-link"><i class="fa fa-home me-2"></i>Dashboard</a></li>
                    <li class="nav-item"><a href="{{ route('produk.index') }}" class="nav-link active"><i class="fa fa-box me-2"></i>Manajemen Produk</a></li>
                    <li class="nav-item"><a href="{{ route('barang.masuk') }}" class="nav-link"><i class="fa fa-arrow-down me-2"></i>Barang Masuk</a></li>
                    <li class="nav-item"><a href="{{ route('barang.keluar') }}" class="nav-link"><i class="fa fa-arrow-up me-2"></i>Barang Keluar</a></li>
                    <li class="nav-item"><a href="{{ route('riwayat.transaksi') }}" class="nav-link"><i class="fa fa-history me-2"></i>Riwayat Transaksi</a></li>
                    <li class="nav-item"><a href="{{ route('laporan') }}" class="nav-link"><i class="fa fa-file-alt me-2"></i>Laporan & Export</a></li>
                </ul>
                
                <!-- Logout Button -->
                <div class="mt-4 pt-3 border-top">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="btn btn-outline-light w-100">
                            <i class="fa fa-sign-out-alt me-2"></i>Logout
                        </button>
                    </form>
                </div>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 main-content">
            <div class="detail-card">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="fw-bold mb-0">
                        <i class="fa fa-eye me-2"></i>Detail Produk
                    </h3>
                    <div class="d-flex gap-2">
                        <a href="{{ route('produk.index') }}" class="btn btn-secondary">
                            <i class="fa fa-arrow-left me-2"></i>Kembali
                        </a>
                        <a href="{{ route('produk.edit', $produk->id) }}" class="btn btn-primary">
                            <i class="fa fa-edit me-2"></i>Edit
                        </a>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4 text-center">
                        <div class="card">
                            <div class="card-body">
                                @if($produk->foto)
                                    <img src="{{ asset('storage/' . $produk->foto) }}" 
                                         class="produk-image mb-3" alt="Foto Produk">
                                @else
                                    <div class="text-muted mb-3">
                                        <i class="fa fa-image fa-5x"></i>
                                        <p class="mt-2">Tidak ada foto</p>
                                    </div>
                                @endif
                                
                                <h5 class="card-title">{{ $produk->nama }}</h5>
                                
                                @if($produk->stok > 10)
                                    <span class="badge bg-success status-badge">
                                        <i class="fa fa-check-circle me-1"></i>Tersedia
                                    </span>
                                @elseif($produk->stok > 5)
                                    <span class="badge bg-warning status-badge">
                                        <i class="fa fa-exclamation-triangle me-1"></i>Stok Menipis
                                    </span>
                                @else
                                    <span class="badge bg-danger status-badge">
                                        <i class="fa fa-times-circle me-1"></i>Hampir Habis
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <i class="fa fa-info-circle me-2"></i>Informasi Produk
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td class="fw-bold">ID Produk:</td>
                                                <td>{{ $produk->id }}</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold">Nama Produk:</td>
                                                <td>{{ $produk->nama }}</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold">Stok Saat Ini:</td>
                                                <td>
                                                    <span class="badge bg-{{ $produk->stok > 10 ? 'success' : ($produk->stok > 5 ? 'warning' : 'danger') }} fs-6">
                                                        {{ $produk->stok }} unit
                                                    </span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td class="fw-bold">Dibuat:</td>
                                                <td>{{ $produk->created_at->format('d/m/Y H:i') }}</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold">Terakhir Update:</td>
                                                <td>{{ $produk->updated_at->format('d/m/Y H:i') }}</td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold">Status:</td>
                                                <td>
                                                    @if($produk->stok > 10)
                                                        <span class="text-success">Tersedia</span>
                                                    @elseif($produk->stok > 5)
                                                        <span class="text-warning">Stok Menipis</span>
                                                    @else
                                                        <span class="text-danger">Hampir Habis</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <i class="fa fa-chart-line me-2"></i>Statistik
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row text-center">
                                    <div class="col-md-4">
                                        <div class="border rounded p-3">
                                            <h4 class="text-primary mb-1">{{ $produk->stok }}</h4>
                                            <small class="text-muted">Stok Tersedia</small>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="border rounded p-3">
                                            <h4 class="text-info mb-1">{{ $produk->transaksis->count() }}</h4>
                                            <small class="text-muted">Total Transaksi</small>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="border rounded p-3">
                                            <h4 class="text-success mb-1">{{ $produk->transaksis->where('jenis', 'masuk')->count() }}</h4>
                                            <small class="text-muted">Barang Masuk</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <i class="fa fa-history me-2"></i>Riwayat Transaksi Terbaru
                                </h5>
                            </div>
                            <div class="card-body">
                                @if($produk->transaksis->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Tanggal</th>
                                                    <th>Jenis</th>
                                                    <th>Jumlah</th>
                                                    <th>Kode</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($produk->transaksis->take(5) as $transaksi)
                                                    <tr>
                                                        <td>{{ $transaksi->created_at->format('d/m/Y H:i') }}</td>
                                                        <td>
                                                            @if($transaksi->jenis === 'masuk')
                                                                <span class="badge bg-success">Masuk</span>
                                                            @else
                                                                <span class="badge bg-danger">Keluar</span>
                                                            @endif
                                                        </td>
                                                        <td>{{ $transaksi->jumlah }}</td>
                                                        <td>{{ $transaksi->kode_transaksi }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <p class="text-muted text-center">Belum ada transaksi untuk produk ini.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 