<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        User::create([
            'name' => 'Administrator',
            'email' => 'admin@admin.com',
            'password' => Hash::make('password'),
        ]);

        User::create([
            'name' => 'Staff Gudang',
            'email' => 'staff@staff.com',
            'password' => Hash::make('password'),
        ]);

        // Dev account for quick login during local development
        User::create([
            'name' => 'Developer',
            'email' => 'dev@local.test',
            'password' => Hash::make('password123'),
        ]);
    }
}
