<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add missing columns used by the app/views/controllers if they don't exist
        if (!Schema::hasTable('transaksis')) {
            return;
        }

        if (!Schema::hasColumn('transaksis', 'kode_transaksi')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->string('kode_transaksi')->nullable();
            });
        }

        if (!Schema::hasColumn('transaksis', 'jenis')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->string('jenis')->nullable();
            });
        }

        if (!Schema::hasColumn('transaksis', 'produk_id')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->unsignedBigInteger('produk_id')->nullable();
            });
        }

        if (!Schema::hasColumn('transaksis', 'jumlah')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->integer('jumlah')->default(0);
            });
        }

        if (!Schema::hasColumn('transaksis', 'tanggal')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->date('tanggal')->nullable();
            });
        }

        if (!Schema::hasColumn('transaksis', 'keterangan')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->text('keterangan')->nullable();
            });
        }

        if (!Schema::hasColumn('transaksis', 'nama_bagian')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->string('nama_bagian')->nullable();
            });
        }

        if (!Schema::hasColumn('transaksis', 'user_id')) {
            Schema::table('transaksis', function (Blueprint $table) {
                $table->unsignedBigInteger('user_id')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (!Schema::hasTable('transaksis')) {
            return;
        }

        Schema::table('transaksis', function (Blueprint $table) {
            if (Schema::hasColumn('transaksis', 'kode_transaksi')) $table->dropColumn('kode_transaksi');
            if (Schema::hasColumn('transaksis', 'jenis')) $table->dropColumn('jenis');
            if (Schema::hasColumn('transaksis', 'produk_id')) $table->dropColumn('produk_id');
            if (Schema::hasColumn('transaksis', 'jumlah')) $table->dropColumn('jumlah');
            if (Schema::hasColumn('transaksis', 'tanggal')) $table->dropColumn('tanggal');
            if (Schema::hasColumn('transaksis', 'keterangan')) $table->dropColumn('keterangan');
            if (Schema::hasColumn('transaksis', 'nama_bagian')) $table->dropColumn('nama_bagian');
            if (Schema::hasColumn('transaksis', 'user_id')) $table->dropColumn('user_id');
        });
    }
};
