<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: linear-gradient(135deg, rgba(15,23,42,0.92), rgba(30,64,175,0.9));
        padding: 2rem;
        border-radius: 18px;
        margin-bottom: 2rem;
        box-shadow: 0 20px 55px rgba(0,0,0,0.35);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
        border: 1px solid rgba(148,163,184,0.4);
    }
    .admin-header h1 {
        color: #f8fafc;
        margin: 0;
    }
    .admin-header .btn {
        box-shadow: 0 10px 30px rgba(37,99,235,0.35);
    }
    .card {
        background: linear-gradient(135deg, rgba(15,23,42,0.94), rgba(30,64,175,0.9));
        border: 1px solid rgba(148,163,184,0.35);
        box-shadow: 0 22px 60px rgba(0,0,0,0.4);
    }
    .card label {
        color: #e5e7eb;
        font-weight: 600;
    }
    .form-control {
        background: rgba(15,23,42,0.9);
        color: #e5e7eb;
        border: 1px solid rgba(148,163,184,0.6);
        box-shadow: 0 10px 30px rgba(0,0,0,0.35);
    }
    .form-control::placeholder {
        color: #cbd5f5;
    }
    .form-control option {
        color: #0f172a;
        background: #e5e7eb;
    }
    .btn.submit-btn {
        padding: 10px 22px;
        background: linear-gradient(135deg, #2563eb, #0ea5e9);
        color: #f8fafc;
        border: none;
        border-radius: 12px;
        box-shadow: 0 10px 26px rgba(37,99,235,0.35);
    }
    .current-photo {
        margin-top: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
        color: #cbd5f5;
    }
    .current-photo img {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid rgba(148,163,184,0.6);
        box-shadow: 0 8px 20px rgba(0,0,0,0.35);
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-edit"></i> Edit Pendidikan</h1>
            <a href="<?= base_url('admin/pendidikan') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <?php if ($pendidikan): ?>
            <form method="POST" action="<?= base_url('admin/pendidikan/edit/' . $pendidikan['id']) ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Jenjang *</label>
                    <select name="jenjang" class="form-control" required>
                        <option value="">Pilih Jenjang</option>
                        <option value="SD" <?= $pendidikan['jenjang'] === 'SD' ? 'selected' : '' ?>>SD</option>
                        <option value="SMP" <?= $pendidikan['jenjang'] === 'SMP' ? 'selected' : '' ?>>SMP</option>
                        <option value="SMA" <?= $pendidikan['jenjang'] === 'SMA' ? 'selected' : '' ?>>SMA</option>
                        <option value="S1" <?= $pendidikan['jenjang'] === 'S1' ? 'selected' : '' ?>>S1</option>
                        <option value="S2" <?= $pendidikan['jenjang'] === 'S2' ? 'selected' : '' ?>>S2</option>
                        <option value="S3" <?= $pendidikan['jenjang'] === 'S3' ? 'selected' : '' ?>>S3</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Institusi *</label>
                    <input type="text" name="institusi" class="form-control" value="<?= esc($pendidikan['institusi']) ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Jurusan</label>
                    <input type="text" name="jurusan" class="form-control" value="<?= esc($pendidikan['jurusan']) ?>">
                </div>
                
                <div class="form-group">
                    <label>Tahun Mulai</label>
                    <input type="number" name="tahun_mulai" class="form-control" value="<?= esc($pendidikan['tahun_mulai']) ?>" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Tahun Selesai</label>
                    <input type="number" name="tahun_selesai" class="form-control" value="<?= esc($pendidikan['tahun_selesai']) ?>" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="5"><?= esc($pendidikan['deskripsi']) ?></textarea>
                </div>

                <div class="form-group">
                    <label>Foto Institusi (opsional)</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    <?php if (!empty($pendidikan['foto'])): ?>
                    <div class="current-photo">
                        <img src="<?= base_url(esc($pendidikan['foto'])) ?>" alt="Foto institusi">
                        <small>Foto saat ini. Unggah file baru untuk mengganti.</small>
                    </div>
                    <?php endif; ?>
                </div>
                
                <button type="submit" class="btn submit-btn">
                    <i class="fas fa-save"></i> Update
                </button>
            </form>
            <?php else: ?>
            <p>Data tidak ditemukan</p>
            <?php endif; ?>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
