<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: radial-gradient(circle at 20% 20%, rgba(59,130,246,0.25), transparent 35%),
                        radial-gradient(circle at 80% 30%, rgba(14,165,233,0.22), transparent 38%),
                        radial-gradient(circle at 50% 80%, rgba(34,197,94,0.16), transparent 40%),
                        linear-gradient(135deg, #0b1024, #0f172a 50%, #0b1228);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 32px 18px;
        }
        .login-container {
            position: relative;
            background: rgba(15,23,42,0.82);
            border-radius: 22px;
            padding: 3rem 2.6rem;
            box-shadow: 0 24px 70px rgba(0,0,0,0.45);
            max-width: 420px;
            width: 100%;
            border: 1px solid rgba(148,163,184,0.35);
            backdrop-filter: blur(14px);
        }
        .login-container::before {
            content: '';
            position: absolute;
            inset: 12px;
            border-radius: 18px;
            border: 1px solid rgba(79,70,229,0.2);
            pointer-events: none;
        }
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        .login-header h1 {
            color: #e2e8f0;
            font-size: 2rem;
            margin-bottom: 0.5rem;
            letter-spacing: 0.01em;
        }
        .login-header p {
            color: #cbd5f5;
            font-weight: 400;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: #e2e8f0;
            font-weight: 600;
            letter-spacing: 0.01em;
        }
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid rgba(148,163,184,0.5);
            border-radius: 12px;
            font-family: 'Poppins', sans-serif;
            font-size: 1rem;
            transition: border-color 0.25s, box-shadow 0.25s;
            background: rgba(15,23,42,0.9);
            color: #e2e8f0;
            box-shadow: 0 6px 18px rgba(0,0,0,0.25);
        }
        .form-control:focus {
            outline: none;
            border-color: #38bdf8;
            box-shadow: 0 0 0 3px rgba(56,189,248,0.18);
        }
        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #2563eb, #0ea5e9);
            color: #f8fafc;
            border: none;
            border-radius: 12px;
            font-family: 'Poppins', sans-serif;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.25s, box-shadow 0.25s, opacity 0.2s;
            box-shadow: 0 12px 28px rgba(37,99,235,0.35);
        }
        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 16px 36px rgba(37,99,235,0.42);
        }
        .alert {
            padding: 12px;
            border-radius: 10px;
            margin-bottom: 1.5rem;
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
            box-shadow: 0 10px 26px rgba(0,0,0,0.18);
        }
        .alert.success {
            background: #dcfce7;
            color: #166534;
            border: 1px solid #bbf7d0;
        }
        .back-link {
            text-align: center;
            margin-top: 1.5rem;
        }
        .back-link a {
            color: #cbd5f5;
            text-decoration: none;
            font-size: 0.92rem;
            font-weight: 500;
        }
        .back-link a:hover {
            color: #38bdf8;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1><i class="fas fa-lock"></i> Admin Login</h1>
            <p>Masuk ke panel admin</p>
        </div>
        
        <?php if (!empty($login_success)): ?>
            <div class="alert success">
                <i class="fas fa-check-circle"></i> <?= esc($login_success) ?>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($error)): ?>
            <div class="alert">
                <i class="fas fa-exclamation-circle"></i> <?= esc($error) ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="<?= base_url('admin/login') ?>" id="loginForm">
            <!-- CSRF disabled for admin routes -->
            <div class="form-group">
                <label for="username"><i class="fas fa-user"></i> Username</label>
                <input type="text" id="username" name="username" class="form-control" required autofocus value="<?= old('username') ?? ($old_username ?? '') ?>">
            </div>
            
            <div class="form-group">
                <label for="password"><i class="fas fa-key"></i> Password</label>
                <input type="password" id="password" name="password" class="form-control" required value="">
            </div>
            
            <button type="submit" class="btn" id="loginBtn">
                <i class="fas fa-sign-in-alt"></i> Login
            </button>
        </form>
        
        <div class="back-link">
            <a href="<?= base_url() ?>"><i class="fas fa-arrow-left"></i> Kembali ke Home</a>
        </div>
    </div>
</body>
</html>
