<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: linear-gradient(135deg, rgba(15,23,42,0.98), rgba(15,23,42,0.92));
        padding: 1.75rem 2rem;
        border-radius: 18px;
        margin-bottom: 2rem;
        box-shadow: 0 20px 60px rgba(15,23,42,0.95);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
        border: 1px solid rgba(51,65,85,0.9);
    }
    .admin-header h1 {
        margin: 0;
        font-size: 1.6rem;
        color: #e5e7eb;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }
    .admin-header h1 i {
        color: #38bdf8;
    }
    .dashboard-grid {
        display: grid;
        grid-template-columns: minmax(0, 2fr) minmax(0, 1.6fr);
        gap: 1.5rem;
        align-items: stretch;
    }
    @media (max-width: 900px) {
        .dashboard-grid {
            grid-template-columns: 1fr;
        }
    }
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
        gap: 1.25rem;
    }
    .stat-card {
        background: rgba(15,23,42,0.96);
        padding: 1.5rem 1.7rem;
        border-radius: 18px;
        box-shadow: 0 20px 50px rgba(15,23,42,0.95);
        text-align: left;
        transition: transform 0.3s;
        border: 1px solid rgba(51,65,85,0.95);
        display: flex;
        flex-direction: column;
        gap: 0.35rem;
    }
    .stat-card:hover {
        transform: translateY(-5px);
    }
    .stat-card i {
        font-size: 3rem;
        margin-bottom: 1rem;
        background: linear-gradient(135deg, #38bdf8, #22c55e);
        -webkit-background-clip: text;
        background-clip: text;
        color: transparent;
    }
    .stat-card h3 {
        font-size: 2.4rem;
        margin: 0.5rem 0;
        color: #38bdf8;
    }
    .stat-card p {
        color: #cbd5f5;
        margin: 0;
    }
    .side-card {
        height: 100%;
        background: rgba(15,23,42,0.97);
        border-radius: 18px;
        padding: 1.7rem 1.8rem;
        box-shadow: 0 22px 55px rgba(15,23,42,0.96);
        border: 1px solid rgba(51,65,85,0.95);
        display: flex;
        flex-direction: column;
        gap: 1.25rem;
    }
    .side-card h2 {
        margin: 0;
        font-size: 1.2rem;
        color: #e5e7eb;
    }
    .quick-actions {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
    }
    .action-btn {
        display: block;
        padding: 1.4rem;
        background: rgba(15,23,42,0.96);
        border-radius: 16px;
        text-decoration: none;
        text-align: center;
        box-shadow: 0 18px 40px rgba(15,23,42,0.9);
        transition: transform 0.3s, box-shadow 0.3s;
        color: #e5e7eb;
        border: 1px solid rgba(51,65,85,0.95);
    }
    .action-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 22px 55px rgba(15,23,42,0.95);
        color: #38bdf8;
    }
    .action-btn i {
        font-size: 2rem;
        margin-bottom: 0.5rem;
        display: block;
    }
</style>

<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-tachometer-alt"></i> Dashboard Admin</h1>
            <a href="<?= base_url('admin/logout') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>

        <div class="dashboard-grid">
            <div>
                <div class="stats-grid">
                    <div class="stat-card">
                        <i class="fas fa-user"></i>
                        <h3><?= $biodata_count ?></h3>
                        <p>Biodata</p>
                    </div>
                    <div class="stat-card">
                        <i class="fas fa-graduation-cap"></i>
                        <h3><?= $pendidikan_count ?></h3>
                        <p>Pendidikan</p>
                    </div>
                    <div class="stat-card">
                        <i class="fas fa-calendar-check"></i>
                        <h3><?= $aktivitas_count ?></h3>
                        <p>Aktivitas</p>
                    </div>
                </div>
            </div>
            <div>
                <div class="side-card">
                    <h2>Quick Actions</h2>
                    <div class="quick-actions">
                        <a href="<?= base_url('admin/biodata') ?>" class="action-btn">
                            <i class="fas fa-user-edit"></i>
                            <strong>Kelola Biodata</strong>
                        </a>
                        <a href="<?= base_url('admin/pendidikan') ?>" class="action-btn">
                            <i class="fas fa-school"></i>
                            <strong>Kelola Pendidikan</strong>
                        </a>
                        <a href="<?= base_url('admin/aktivitas') ?>" class="action-btn">
                            <i class="fas fa-images"></i>
                            <strong>Kelola Aktivitas</strong>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?= $this->endSection() ?>


