<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-edit"></i> Edit Biodata</h1>
            <a href="<?= base_url('admin/biodata') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <?php if ($biodata): ?>
            <form method="POST" action="<?= base_url('admin/biodata/edit/' . $biodata['id']) ?>">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Nama *</label>
                    <input type="text" name="nama" class="form-control" value="<?= esc($biodata['nama']) ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Alamat</label>
                    <textarea name="alamat" class="form-control" rows="3"><?= esc($biodata['alamat']) ?></textarea>
                </div>
                
                <div class="form-group">
                    <label>Email *</label>
                    <input type="email" name="email" class="form-control" value="<?= esc($biodata['email']) ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Telepon</label>
                    <input type="text" name="telepon" class="form-control" value="<?= esc($biodata['telepon']) ?>">
                </div>
                
                <div class="form-group">
                    <label>Foto (Path)</label>
                    <input type="text" name="foto" class="form-control" value="<?= esc($biodata['foto']) ?>" placeholder="uploads/foto.jpg">
                </div>
                
                <div class="form-group">
                    <label>Tentang</label>
                    <textarea name="tentang" class="form-control" rows="5"><?= esc($biodata['tentang']) ?></textarea>
                </div>
                
                <div class="form-group">
                    <label>Keahlian</label>
                    <textarea name="keahlian" class="form-control" rows="3"><?= esc($biodata['keahlian']) ?></textarea>
                </div>
                
                <div class="form-group">
                    <label>Pengalaman</label>
                    <textarea name="pengalaman" class="form-control" rows="3"><?= esc($biodata['pengalaman']) ?></textarea>
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-save"></i> Update
                </button>
            </form>
            <?php else: ?>
            <p>Data tidak ditemukan</p>
            <?php endif; ?>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
