<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: linear-gradient(135deg, rgba(15,23,42,0.92), rgba(30,64,175,0.9));
        padding: 2rem;
        border-radius: 18px;
        margin-bottom: 2rem;
        box-shadow: 0 20px 55px rgba(0,0,0,0.35);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
        border: 1px solid rgba(148,163,184,0.4);
    }
    .admin-header h1 {
        color: #f8fafc;
        margin: 0;
    }
    .admin-header .btn {
        box-shadow: 0 10px 30px rgba(37,99,235,0.35);
    }
    .card {
        background: linear-gradient(135deg, rgba(15,23,42,0.94), rgba(30,64,175,0.9));
        border: 1px solid rgba(148,163,184,0.35);
        box-shadow: 0 22px 60px rgba(0,0,0,0.4);
    }
    .card label {
        color: #e5e7eb;
        font-weight: 600;
    }
    .form-control {
        background: rgba(15,23,42,0.9);
        color: #e5e7eb;
        border: 1px solid rgba(148,163,184,0.6);
        box-shadow: 0 10px 30px rgba(0,0,0,0.35);
    }
    .form-control::placeholder {
        color: #cbd5f5;
    }
    .form-control option {
        color: #0f172a;
        background: #e5e7eb;
    }
    .btn.submit-btn {
        padding: 10px 22px;
        background: linear-gradient(135deg, #2563eb, #0ea5e9);
        color: #f8fafc;
        border: none;
        border-radius: 12px;
        box-shadow: 0 10px 26px rgba(37,99,235,0.35);
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-plus"></i> Tambah Aktivitas</h1>
            <a href="<?= base_url('admin/aktivitas') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <form method="POST" action="<?= base_url('admin/aktivitas/create') ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Nama Aktivitas *</label>
                    <input type="text" name="nama_aktivitas" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Jam</label>
                    <input type="time" name="jam" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="5"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Jenis *</label>
                    <select name="jenis" class="form-control" required>
                        <option value="">Pilih Jenis</option>
                        <option value="foto">Foto</option>
                        <option value="video">Video</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>File Aktivitas (Foto / Video)</label>
                    <input type="file" name="file_aktivitas" class="form-control" accept="image/*,video/*">
                    <small style="margin-top: 0.35rem; color: #9ca3af;">Format yang didukung: gambar (JPG/PNG) atau video (MP4).</small>
                </div>
                
                <button type="submit" class="btn submit-btn">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
