<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<section style="padding-top: 100px;">
    <div class="container" style="max-width: 1200px;">
        <h2 class="section-title" style="text-align: left; margin-left: 0;">Riwayat Pendidikan</h2>

        <style>
            .edu-timeline {
                position: relative;
                margin-top: 1.5rem;
            }
            .edu-timeline::before {
                content: '';
                position: absolute;
                left: 20px;
                top: 0;
                bottom: 0;
                width: 2px;
                background: linear-gradient(to bottom, rgba(56,189,248,0.5), rgba(34,197,94,0.25));
            }
            .edu-item {
                position: relative;
                display: flex;
                gap: 1.5rem;
                margin-bottom: 1.5rem;
            }
            .edu-marker {
                position: relative;
                width: 40px;
                flex-shrink: 0;
                display: flex;
                justify-content: center;
            }
            .edu-marker-dot {
                width: 16px;
                height: 16px;
                border-radius: 999px;
                background: radial-gradient(circle, #38bdf8 0%, #0ea5e9 40%, #0f172a 100%);
                border: 2px solid #0f172a;
                box-shadow: 0 0 0 4px rgba(56,189,248,0.35);
                margin-top: 6px;
            }
            .edu-card {
                flex: 1;
                border-radius: 18px;
                padding: 1.4rem 1.5rem;
                background: rgba(15,23,42,0.96);
                border: 1px solid rgba(51,65,85,0.95);
                box-shadow: 0 18px 45px rgba(15,23,42,0.95);
            }
            .edu-card-content {
                display: grid;
                grid-template-columns: auto 1fr;
                gap: 1rem;
                align-items: center;
            }
            .edu-avatar {
                width: 56px;
                height: 56px;
                border-radius: 50%;
                background: linear-gradient(135deg, #2563eb, #0ea5e9);
                display: flex;
                align-items: center;
                justify-content: center;
                color: #f8fafc;
                font-weight: 700;
                font-size: 1.2rem;
                box-shadow: 0 12px 30px rgba(37,99,235,0.35);
                border: 2px solid rgba(148,163,184,0.45);
            }
            .edu-avatar img {
                width: 100%;
                height: 100%;
                object-fit: cover;
                border-radius: 50%;
            }
            .edu-header-row {
                display: flex;
                justify-content: space-between;
                align-items: baseline;
                gap: 0.75rem;
                margin-bottom: 0.25rem;
            }
            .edu-jenjang-pill {
                display: inline-flex;
                align-items: center;
                padding: 4px 10px;
                border-radius: 999px;
                background: rgba(15,23,42,0.95);
                border: 1px solid rgba(148,163,184,0.9);
                font-size: 0.8rem;
                letter-spacing: 0.05em;
                text-transform: uppercase;
                color: #e5e7eb;
            }
            .edu-institusi {
                font-size: 1.1rem;
                font-weight: 600;
                color: #e5e7eb;
            }
            .edu-meta {
                color: #9ca3af;
                font-size: 0.9rem;
            }
        </style>

        <form method="GET" style="margin-top: 0.5rem; margin-bottom: 1rem; display: flex; flex-wrap: wrap; gap: 0.75rem; align-items: center;">
            <input type="text" name="q" class="form-control" placeholder="Cari institusi..." value="<?= esc($search ?? '') ?>" style="max-width: 260px;">
            <select name="jenjang" class="form-control" style="max-width: 170px;">
                <option value="">Semua Jenjang</option>
                <?php foreach (['PAUD','TK','SD','SMP','SMA','SMK','D3','S1','S2','S3'] as $opt): ?>
                    <option value="<?= $opt ?>" <?= ($filter_jenjang ?? '') === $opt ? 'selected' : '' ?>><?= $opt ?></option>
                <?php endforeach; ?>
            </select>
            <select name="sort" class="form-control" style="max-width: 200px;">
                <option value="tahun_selesai" <?= ($sort ?? '') === 'tahun_selesai' ? 'selected' : '' ?>>Urutkan: Tahun Selesai</option>
                <option value="tahun_mulai" <?= ($sort ?? '') === 'tahun_mulai' ? 'selected' : '' ?>>Urutkan: Tahun Mulai</option>
                <option value="jenjang" <?= ($sort ?? '') === 'jenjang' ? 'selected' : '' ?>>Urutkan: Jenjang</option>
                <option value="institusi" <?= ($sort ?? '') === 'institusi' ? 'selected' : '' ?>>Urutkan: Institusi</option>
            </select>
            <select name="dir" class="form-control" style="max-width: 150px;">
                <option value="desc" <?= ($dir ?? '') === 'desc' ? 'selected' : '' ?>>Terbaru &rarr; Lama</option>
                <option value="asc" <?= ($dir ?? '') === 'asc' ? 'selected' : '' ?>>Lama &rarr; Terbaru</option>
            </select>
            <button type="submit" class="btn" style="padding: 8px 18px;">Terapkan</button>
        </form>
        
        <?php if (!empty($pendidikan)): ?>
        <div class="edu-timeline">
            <?php foreach ($pendidikan as $item): ?>
            <div class="edu-item">
                <div class="edu-marker">
                    <div class="edu-marker-dot"></div>
                </div>
                <div class="edu-card">
                    <?php
                        $initial = !empty($item['institusi']) ? strtoupper(substr($item['institusi'], 0, 1)) : '?';
                        $foto = !empty($item['foto']) ? $item['foto'] : null;
                    ?>
                    <div class="edu-card-content">
                        <div class="edu-avatar">
                            <?php if ($foto): ?>
                                <a href="<?= base_url(esc($foto)) ?>" target="_blank" rel="noopener" style="display:block; width:100%; height:100%; border-radius:50%; overflow:hidden;">
                                    <img src="<?= base_url(esc($foto)) ?>" alt="Foto <?= esc($item['institusi']) ?>">
                                </a>
                            <?php else: ?>
                                <?= esc($initial) ?>
                            <?php endif; ?>
                        </div>
                        <div>
                            <div class="edu-header-row">
                                <span class="edu-jenjang-pill"><?= esc($item['jenjang']) ?></span>
                                <?php if (!empty($item['tahun_mulai']) && !empty($item['tahun_selesai'])): ?>
                                <span class="edu-meta"><i class="fas fa-calendar"></i> <?= esc($item['tahun_mulai']) ?> - <?= esc($item['tahun_selesai']) ?></span>
                                <?php endif; ?>
                            </div>
                            <p class="edu-institusi" style="margin-bottom: 0.15rem;"><?= esc($item['institusi']) ?></p>
                            <?php if (!empty($item['jurusan']) && $item['jurusan'] !== '-'): ?>
                            <p class="edu-meta" style="margin-top: 0.2rem;"><i class="fas fa-graduation-cap"></i> <?= esc($item['jurusan']) ?></p>
                            <?php endif; ?>
                            <?php if (!empty($item['deskripsi'])): ?>
                            <p class="edu-meta" style="margin-top: 0.55rem; color: #cbd5f5;"><?= nl2br(esc($item['deskripsi'])) ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php if (isset($pager)): ?>
        <div class="pagination" style="margin-top: 1rem;">
            <?= $pager->links('pendidikan_front', 'default_full') ?>
        </div>
        <?php endif; ?>
        <?php else: ?>
        <div class="empty-state">
            <p>Data pendidikan belum tersedia.</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>

