<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? esc($title) : 'Portfolio Digital' ?></title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
    
    <!-- Three.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
    
    <style>
        :root {
            --primary-color: #1d4ed8; /* deep blue */
            --secondary-color: #0f766e; /* teal */
            --dark-color: #0b1120;
            --light-color: #0f172a;
            --accent-color: #f97316; /* warm accent */
            --gradient: linear-gradient(135deg, #1d4ed8, #0f766e);
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: radial-gradient(circle at top left, #1d4ed8 0%, transparent 55%),
                        radial-gradient(circle at bottom right, #0f766e 0%, transparent 55%),
                        linear-gradient(180deg, #020617 0%, #020617 35%, #0b1120 100%);
            color: #e5e7eb;
            line-height: 1.6;
            overflow-x: hidden;
        }
        
        .container {
            max-width: 1180px;
            width: 100%;
            margin: 0 auto;
            padding: 0 24px;
        }
        
        /* Navigation */
        .navbar {
            background: linear-gradient(135deg, rgba(15,23,42,0.96), rgba(15,23,42,0.9));
            backdrop-filter: blur(16px);
            padding: 0.9rem 0;
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
            box-shadow: 0 10px 30px rgba(15,23,42,0.8);
            border-bottom: 1px solid rgba(30,64,175,0.6);
        }
        
        .nav-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
        }
        
        .logo {
            font-family: 'Montserrat', sans-serif;
            font-size: 1.8rem;
            font-weight: 600;
            background: var(--gradient);
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
        }
        
        .nav-links {
            display: flex;
            align-items: center;
            gap: 2rem;
            list-style: none;
        }
        
        .nav-links a {
            text-decoration: none;
            color: #e5e7eb;
            font-weight: 500;
            transition: color 0.3s;
            position: relative;
            padding-bottom: 4px;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .nav-links a::after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--gradient);
            transition: width 0.3s;
        }
        
        .nav-links a.active::after {
            width: 100%;
        }

        .nav-links a:hover::after {
            width: 100%;
        }

        .mobile-menu-btn {
            display: none;
            background: rgba(255,255,255,0.08);
            border: 1px solid rgba(255,255,255,0.2);
            color: #e5e7eb;
            padding: 8px 12px;
            border-radius: 12px;
            cursor: pointer;
            transition: background 0.3s, transform 0.3s;
        }

        .mobile-menu-btn:hover {
            background: rgba(255,255,255,0.16);
            transform: translateY(-1px);
        }
        
        /* Hero Section */
        .hero {
            min-height: 100vh;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            align-items: center;
            gap: 2rem;
            padding: 140px 0 90px;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            inset: 0;
            background:
                radial-gradient(780px circle at 15% 15%, rgba(59,130,246,0.28), transparent),
                radial-gradient(820px circle at 85% 25%, rgba(34,197,94,0.22), transparent),
                radial-gradient(900px circle at 50% 100%, rgba(15,118,110,0.3), transparent);
            z-index: 0;
        }
        
        #canvas3d {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
            pointer-events: none;
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
            max-width: 640px;
            margin: 0 auto;
            padding: 36px 0;
            text-align: center;
            background: transparent;
            border: none;
            box-shadow: none;
        }
        
        .hero h1 {
            font-size: clamp(2.4rem, 4vw, 3.6rem);
            font-weight: 700;
            margin-bottom: 1rem;
            color: #f9fafb;
        }
        
        .hero p {
            font-size: 1.2rem;
            color: #e5e7eb;
            margin-bottom: 2rem;
        }

        .hero .tagline {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 8px 14px;
            border-radius: 999px;
            background: rgba(15,23,42,0.9);
            color: #f9fafb;
            border: 1px solid rgba(148,163,184,0.7);
            box-shadow: 0 12px 30px rgba(15,23,42,0.85);
            font-weight: 600;
            margin-bottom: 16px;
            font-size: 0.95rem;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: var(--gradient);
            color: white;
            border: none;
            border-radius: 30px;
            text-decoration: none;
            font-weight: 500;
            cursor: pointer;
            transition: transform 0.3s, box-shadow 0.3s;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(37, 99, 235, 0.4);
        }

        .btn.secondary {
            background: transparent;
            color: var(--primary-color);
            border: 2px solid #dbeafe;
            box-shadow: none;
        }

        .btn.secondary:hover {
            background: #eff6ff;
            box-shadow: none;
        }
        
        /* Sections */
        section {
            padding: 100px 0;
            scroll-margin-top: 90px;
        }
        
        .section-title {
            text-align: center;
            font-size: 2.5rem;
            margin: 0 auto 3rem auto;
            position: relative;
            color: #e5e7eb;
            width: fit-content;
            max-width: 100%;
            padding-bottom: 0.4rem;
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 0;
            transform: none;
            width: 100%;
            height: 4px;
            background: var(--gradient);
            border-radius: 2px;
        }

        .muted {
            color: #64748b;
        }

        /* Make text readable on dark about card */
        #about .muted {
            color: #e5e7eb;
        }

        .pill {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            background: rgba(15,23,42,0.8);
            color: #e5e7eb;
            border-radius: 999px;
            font-size: 0.95rem;
            font-weight: 600;
        }

        .card-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
            gap: 1.5rem;
        }
        
        /* Cards */
        .card {
            background: rgba(15,23,42,0.9);
            border-radius: 20px;
            padding: 2rem;
            box-shadow: 0 12px 35px rgba(0,0,0,0.35);
            transition: transform 0.3s, box-shadow 0.3s;
            border: 1px solid rgba(148,163,184,0.45);
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.12);
        }
        
         /* Filter & Search */
         .filter-section {
            background: rgba(15,23,42,0.9);
            padding: 1.5rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 8px 24px rgba(0,0,0,0.35);
         }
        
        .filter-form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            align-items: end;
        }
        
        .form-group {
            display: flex;
            flex-direction: column;
        }
        
        .form-group label {
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #e5e7eb;
        }
        
        .form-control {
            padding: 10px 15px;
            border: 1px solid rgba(148,163,184,0.5);
            border-radius: 12px;
            font-family: 'Poppins', sans-serif;
            font-size: 1rem;
            transition: border-color 0.25s, box-shadow 0.25s, background 0.25s;
            background: rgba(15,23,42,0.9);
            color: #e5e7eb;
            box-shadow: 0 12px 30px rgba(2,6,23,0.4);
        }

        .form-control::placeholder {
            color: #cbd5e1;
        }
        
        .form-control:focus {
            outline: none;
            border-color: rgba(59,130,246,0.8);
            box-shadow: 0 0 0 3px rgba(59,130,246,0.18);
            background: rgba(15,23,42,0.95);
        }
        
        /* Table */
        .table-container {
            overflow-x: auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        }

        .admin-header h1 {
            color: #0f172a;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.95rem;
            color: #0f172a;
        }
        
        th, td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #e2e8f0;
        }
        
        th {
            background: #f1f5f9;
            font-weight: 600;
            color: var(--dark-color);
            cursor: pointer;
            user-select: none;
        }
        
        th:hover {
            background: #e2e8f0;
        }
        
        tr:hover {
            background: #f8fafc;
        }
        
        /* Pagination */
        .pagination {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            margin-top: 2rem;
        }
        
        .page-item {
            list-style: none;
        }
        
        .page-link {
            display: block;
            padding: 0.5rem 1rem;
            background: white;
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            text-decoration: none;
            color: var(--dark-color);
            transition: all 0.3s;
        }
        
        .page-link:hover {
            background: var(--light-color);
            border-color: var(--primary-color);
        }
        
        .page-item.active .page-link {
            background: var(--gradient);
            color: white;
            border-color: transparent;
        }
        
        /* Gallery */
        .gallery {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 1.5rem;
        }
        
        .gallery-item {
            position: relative;
            border-radius: 15px;
            overflow: hidden;
            aspect-ratio: 16/9;
        }
        
        .gallery-item img, .gallery-item video {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s;
        }
        
        .gallery-item:hover img, .gallery-item:hover video {
            transform: scale(1.05);
        }
        
        .gallery-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(transparent, rgba(0,0,0,0.8));
            padding: 1rem;
            color: white;
            transform: translateY(100%);
            transition: transform 0.3s;
        }
        
        .gallery-item:hover .gallery-overlay {
            transform: translateY(0);
        }

        .empty-state {
            text-align: center;
            padding: 2.5rem;
            color: #94a3b8;
            border: 1px dashed #cbd5e1;
            border-radius: 16px;
            background: #f8fafc;
        }
        
        /* Footer */
        footer {
            background: var(--dark-color);
            color: white;
            padding: 3rem 0;
            text-align: center;
        }
        
        .social-links {
            display: flex;
            justify-content: center;
            gap: 1rem;
            margin-top: 1rem;
        }
        
        .social-links a {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            color: white;
            text-decoration: none;
            transition: background 0.3s, transform 0.3s;
        }
        
        .social-links a:hover {
            background: var(--primary-color);
            transform: translateY(-3px);
        }
        
        /* Responsive */
        @media (max-width: 1024px) {
            .container {
                padding: 0 18px;
            }

            .hero {
                padding: 120px 0 80px;
            }

            section {
                padding: 80px 0;
            }

            .card-grid {
                gap: 1.25rem;
            }

            .gallery {
                grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
            }
        }

        @media (max-width: 768px) {
            .container {
                padding: 0 16px;
            }

            .navbar {
                padding: 0.85rem 0;
            }

            .nav-links {
                display: none;
                flex-direction: column;
                position: fixed;
                inset: 70px 16px auto 16px;
                background: rgba(15,23,42,0.98);
                padding: 1rem;
                border-radius: 14px;
                border: 1px solid rgba(148,163,184,0.35);
                box-shadow: 0 20px 45px rgba(0,0,0,0.35);
                gap: 0.75rem;
                align-items: flex-start;
            }

            .nav-links a {
                color: #e5e7eb;
                width: 100%;
            }

            .nav-links.open {
                display: flex;
            }

            .mobile-menu-btn {
                display: inline-flex;
            }

            .hero {
                padding: 110px 0 70px;
                gap: 1.5rem;
            }

            .hero h1 {
                font-size: clamp(2rem, 7vw, 2.6rem);
            }

            .hero p {
                font-size: 1.05rem;
            }

            .hero-content {
                text-align: center;
            }

            section {
                padding: 70px 0;
            }

            .section-title {
                font-size: 2.1rem;
            }

            .card-grid {
                grid-template-columns: repeat(auto-fit, minmax(230px, 1fr));
            }

            .gallery {
                grid-template-columns: repeat(auto-fill, minmax(210px, 1fr));
            }

            table {
                font-size: 0.9rem;
            }

            th, td {
                padding: 0.8rem;
            }
        }

        @media (max-width: 480px) {
            .hero {
                padding: 100px 0 60px;
            }

            .hero h1 {
                font-size: 1.9rem;
            }

            .section-title {
                font-size: 1.9rem;
            }

            .btn {
                width: 100%;
                text-align: center;
            }

            .filter-form {
                grid-template-columns: 1fr;
            }

            .gallery {
                grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            }
        }
    </style>
    
    <?= $this->renderSection('styles') ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="container nav-container">
            <div class="logo">Portfolio<span style="color: var(--accent-color);"></span></div>
            <ul class="nav-links">
                <li><a href="<?= base_url() ?>" class="<?= url_is('/') ? 'active' : '' ?>">Home</a></li>
                <li><a href="<?= base_url('cv') ?>" class="<?= url_is('cv') ? 'active' : '' ?>">Biodata</a></li>
                <li><a href="<?= base_url('pendidikan') ?>" class="<?= url_is('pendidikan') ? 'active' : '' ?>">Pendidikan</a></li>
                <li><a href="<?= base_url('aktivitas') ?>" class="<?= url_is('aktivitas') ? 'active' : '' ?>">Aktivitas</a></li>
                <li><a href="<?= base_url('admin/login') ?>" class="<?= url_is('admin*') ? 'active' : '' ?>">Login</a></li>
            </ul>
            <button class="mobile-menu-btn">
                <i class="fas fa-bars"></i>
            </button>
        </div>
    </nav>

    <!-- Main Content -->
    <main>
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer>
        <div class="container">
            <p>&copy; <?= date('Y') ?> Portfolio Digital. All rights reserved.</p>
            <div class="social-links">
                <a href="https://github.com/sapeeeeii" target="_blank" rel="noopener"><i class="fab fa-github"></i></a>
                <a href="https://www.instagram.com/sapei_104?igsh=ZWt5OXBkeWVkdnky" target="_blank" rel="noopener"><i class="fab fa-instagram"></i></a>
                <a href="https://wa.me/6283895266894" target="_blank" rel="noopener"><i class="fab fa-whatsapp"></i></a>
            </div>
        </div>
    </footer>

    <!-- 3D Script -->
    <script>
        // Three.js 3D Background - floating hexagons & cubes
        function init3DBackground() {
            const heroSection = document.querySelector('.hero');
            if (!heroSection) return;

            const canvas = document.createElement('canvas');
            canvas.id = 'canvas3d';
            heroSection.appendChild(canvas);

            if (!window.THREE || !canvas.getContext('webgl')) {
                // Fallback: keep gradient background only
                return;
            }

            const scene = new THREE.Scene();
            scene.fog = new THREE.FogExp2(0xfdf2ff, 0.035);

            const camera = new THREE.PerspectiveCamera(55, window.innerWidth / window.innerHeight, 0.1, 100);
            camera.position.set(0, 4, 12);

            const renderer = new THREE.WebGLRenderer({ canvas, alpha: true, antialias: true });
            renderer.setSize(window.innerWidth, window.innerHeight);
            renderer.setPixelRatio(Math.min(window.devicePixelRatio || 1, 1.5));

            // Base geometries
            const boxGeometry = new THREE.BoxGeometry(1, 1, 1);
            const hexGeometry = new THREE.CylinderGeometry(1, 1, 0.4, 6);

            const palette = [0x1d4ed8, 0x0ea5e9, 0x22c55e, 0x0f172a, 0x38bdf8];

              const group = new THREE.Group();
              scene.add(group);

              const totalShapes = window.innerWidth < 768 ? 18 : 30;

              for (let i = 0; i < totalShapes; i++) {
                  const useHex = i % 2 === 0;
                  const geom = useHex ? hexGeometry : boxGeometry;
                  const color = palette[Math.floor(Math.random() * palette.length)];

                const material = new THREE.MeshStandardMaterial({
                    color,
                    metalness: 0.45,
                    roughness: 0.25,
                    transparent: true,
                    opacity: 0.95,
                    emissive: 0x000000,
                    emissiveIntensity: 0.25
                  });

                  const mesh = new THREE.Mesh(geom, material);

                    // Tempatkan bentuk jauh di sisi kiri/kanan, menjauh dari tengah hero
                    const minEdge = 10;  // jarak minimal dari tengah
                    const maxEdge = 24;  // jarak maksimal ke samping
                    const side = Math.random() < 0.5 ? -1 : 1;
                    const x = side * (Math.random() * (maxEdge - minEdge) + minEdge);
                    mesh.position.x = x;
                mesh.position.y = (Math.random() * 10) - 3;
                mesh.position.z = - (Math.random() * 18 + 4);

                const scale = Math.random() * 1.4 + 0.6;
                mesh.scale.set(
                    scale * (useHex ? 1.35 : 1),
                    scale * (useHex ? 0.6 : 1.1),
                    scale * (useHex ? 1.35 : 1)
                );

                mesh.rotation.x = Math.random() * Math.PI;
                mesh.rotation.y = Math.random() * Math.PI;

                mesh.userData = {
                    rotSpeedX: (Math.random() * 0.4 + 0.1) * (Math.random() > 0.5 ? 1 : -1),
                    rotSpeedY: (Math.random() * 0.5 + 0.1) * (Math.random() > 0.5 ? 1 : -1),
                    floatOffset: Math.random() * Math.PI * 2,
                    floatAmplitude: Math.random() * 0.35 + 0.2,
                    baseY: mesh.position.y
                };

                  group.add(mesh);
              }

            // Lights
            const keyLight = new THREE.DirectionalLight(0xffffff, 1.0);
            keyLight.position.set(6, 12, 10);
            scene.add(keyLight);

            const rimLight = new THREE.DirectionalLight(0x0ea5e9, 0.7);
            rimLight.position.set(-8, 10, -8);
            scene.add(rimLight);

            const ambient = new THREE.AmbientLight(0x020617, 0.6);
            scene.add(ambient);

            // Animation loop
            function animate(time) {
                requestAnimationFrame(animate);

                const t = time * 0.001;

                group.children.forEach((mesh) => {
                    const data = mesh.userData;
                    mesh.rotation.x += data.rotSpeedX * 0.01;
                    mesh.rotation.y += data.rotSpeedY * 0.01;

                    mesh.position.y = data.baseY + Math.sin(t * 1.1 + data.floatOffset) * data.floatAmplitude;
                });

                  group.position.x = Math.sin(t * 0.18) * 0.6;
                  group.position.z = Math.cos(t * 0.14) * 0.8 - 5;

                renderer.render(scene, camera);
            }

            animate(0);

            // Resize handler
            window.addEventListener('resize', () => {
                camera.aspect = window.innerWidth / window.innerHeight;
                camera.updateProjectionMatrix();
                renderer.setSize(window.innerWidth, window.innerHeight);
            });
        }
        
        // Initialize on load
        document.addEventListener('DOMContentLoaded', function() {
            init3DBackground();
            
            // Mobile Menu
            const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
            const navLinks = document.querySelector('.nav-links');
            if (mobileMenuBtn) {
                mobileMenuBtn.setAttribute('aria-expanded', 'false');
                mobileMenuBtn.addEventListener('click', function() {
                    if (!navLinks) return;
                    const isOpen = navLinks.classList.toggle('open');
                    mobileMenuBtn.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
                });
            }

            if (navLinks) {
                navLinks.querySelectorAll('a').forEach((link) => {
                    link.addEventListener('click', () => {
                        navLinks.classList.remove('open');
                        if (mobileMenuBtn) {
                            mobileMenuBtn.setAttribute('aria-expanded', 'false');
                        }
                    });
                });
            }
        });
    </script>

    <?= $this->renderSection('scripts') ?>
</body>
</html>
