<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<!-- Hero Section -->
<section class="hero">
    <div class="container">
        <div class="hero-content">
            <?php if (isset($biodata) && $biodata): ?>
            <div style="display: flex; flex-direction: column; align-items: center; gap: 8px; margin-bottom: 1.4rem;">
                <div style="width: 170px; height: 170px; border-radius: 50%; overflow: hidden; border: 4px solid var(--primary-color); box-shadow: 0 24px 65px rgba(15,23,42,0.95); background: linear-gradient(135deg, #1d4ed8, #0f766e); display: flex; align-items: center; justify-content: center; color: #eef2ff; font-weight: 600; font-size: 3.4rem;">
                    <?php if (!empty($biodata['foto'])): ?>
                        <img src="<?= base_url(esc($biodata['foto'])) ?>" alt="Foto Profil <?= esc($biodata['nama']) ?>" style="width: 100%; height: 100%; object-fit: cover;">
                    <?php else: ?>
                        <span><?= strtoupper(substr($biodata['nama'], 0, 1)) ?></span>
                    <?php endif; ?>
                </div>
                <p style="margin: 6px 0 0; color: #e5e7eb; font-size: 0.95rem;">Hai, saya</p>
                <h2 style="font-size: 1.9rem; margin: 0; color: #f9fafb; font-weight: 600;"><?= esc($biodata['nama']) ?></h2>
                <p style="font-size: 0.9rem; color: #e5e7eb; margin: 0;"><?= esc($biodata['email']) ?></p>
            </div>
            <?php endif; ?>
            <div class="tagline" style="justify-content: center;"><i class="fas fa-sparkles"></i> Portfolio Digital</div>
            <h1>Selamat Datang di Portfolio Digital</h1>
            <p>Mari jelajahi perjalanan kreatif dan profesional saya melalui portfolio ini.</p>
            <div style="display: flex; gap: 12px; flex-wrap: wrap;">
                <a href="<?= base_url('cv') ?>" class="btn">Lihat CV</a>
                <a href="#about" class="btn secondary">Pelajari Saya</a>
            </div>
            <div style="margin-top: 1.75rem; display: flex; flex-direction: column; gap: 1.1rem;">
                <div style="position: relative; border-radius: 20px; padding: 1.3rem 1.4rem; background: radial-gradient(circle at 0% 0%, rgba(59,130,246,0.18), rgba(15,23,42,0.97)); border: 1px solid rgba(148,163,184,0.7); box-shadow: 0 22px 60px rgba(15,23,42,0.95); backdrop-filter: blur(18px);">
                    <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.55rem;">
                        <div style="width: 34px; height: 34px; border-radius: 12px; background: rgba(15,23,42,0.95); display: flex; align-items: center; justify-content: center; color: #bfdbfe; box-shadow: 0 0 0 1px rgba(59,130,246,0.6);">
                            <i class="fas fa-user"></i>
                        </div>
                        <div>
                            <div style="font-weight: 600; font-size: 0.98rem; color: #e5e7eb;">Profil</div>
                            <div style="font-size: 0.75rem; color: #9ca3af;">Sekilas tentang saya</div>
                        </div>
                    </div>
                    <p class="muted" style="margin: 0; color: #cbd5f5;">Perkenalan ringkas tentang latar, minat, serta keahlian utama saya.</p>
                </div>

                <div style="position: relative; border-radius: 20px; padding: 1.3rem 1.4rem; background: radial-gradient(circle at 0% 0%, rgba(34,197,94,0.16), rgba(15,23,42,0.97)); border: 1px solid rgba(148,163,184,0.7); box-shadow: 0 22px 60px rgba(15,23,42,0.95); backdrop-filter: blur(18px);">
                    <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.55rem;">
                        <div style="width: 34px; height: 34px; border-radius: 12px; background: rgba(15,23,42,0.95); display: flex; align-items: center; justify-content: center; color: #bbf7d0; box-shadow: 0 0 0 1px rgba(34,197,94,0.6);">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div>
                            <div style="font-weight: 600; font-size: 0.98rem; color: #e5e7eb;">Pendidikan</div>
                            <div style="font-size: 0.75rem; color: #9ca3af;">Jejak belajar</div>
                        </div>
                    </div>
                    <p class="muted" style="margin: 0; color: #cbd5f5;">Pengalaman studi yang membentuk cara saya berpikir dan bekerja.</p>
                </div>

                <div style="position: relative; border-radius: 20px; padding: 1.3rem 1.4rem; background: radial-gradient(circle at 0% 0%, rgba(56,189,248,0.18), rgba(15,23,42,0.97)); border: 1px solid rgba(148,163,184,0.7); box-shadow: 0 22px 60px rgba(15,23,42,0.95); backdrop-filter: blur(18px);">
                    <div style="display: flex; align-items: center; gap: 0.75rem; margin-bottom: 0.55rem;">
                        <div style="width: 34px; height: 34px; border-radius: 12px; background: rgba(15,23,42,0.95); display: flex; align-items: center; justify-content: center; color: #bae6fd; box-shadow: 0 0 0 1px rgba(56,189,248,0.6);">
                            <i class="fas fa-clapperboard"></i>
                        </div>
                        <div>
                            <div style="font-weight: 600; font-size: 0.98rem; color: #e5e7eb;">Aktivitas</div>
                            <div style="font-size: 0.75rem; color: #9ca3af;">Proyek & kegiatan</div>
                        </div>
                    </div>
                    <p class="muted" style="margin: 0; color: #cbd5f5;">Dokumentasi semua kegiatan organisasi, termasuk acara, kolaborasi, serta hasil yang berdampak.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About Section -->
<section id="about">
    <div class="container">
        <h2 class="section-title">Tentang Saya</h2>

        <style>
            .about-card {
                display: grid;
                grid-template-columns: minmax(0, 2.2fr) minmax(0, 3fr);
                gap: 2rem;
                align-items: stretch;
                border-radius: 26px;
                border: 1px solid rgba(148,163,184,0.8);
                background: radial-gradient(circle at top left, rgba(59,130,246,0.28), rgba(15,23,42,0.99));
                box-shadow: 0 28px 80px rgba(15,23,42,0.96);
                backdrop-filter: blur(22px);
                padding: 1.5rem 1.6rem;
            }

            .about-left h3 {
                font-size: 1.35rem;
                margin-bottom: 0.75rem;
                color: #e5e7eb;
            }

            .about-left p {
                color: #cbd5f5;
                margin-bottom: 1.25rem;
            }

            .about-left .muted-secondary {
                color: #9ca3af;
                font-size: 0.95rem;
            }

            .about-detail-list {
                display: grid;
                gap: 1rem;
            }

            .about-detail {
                border-radius: 18px;
                border: 1px solid rgba(148,163,184,0.6);
                padding: 1.1rem 1.2rem;
                background: rgba(15,23,42,0.95);
                display: flex;
                gap: 0.85rem;
                align-items: flex-start;
                min-height: 100%;
            }

            .about-pill {
                background: rgba(37,99,235,0.18);
                color: #bfdbfe;
                padding: 6px 10px;
                font-size: 0.8rem;
                border-radius: 999px;
                display: inline-flex;
                align-items: center;
                gap: 0.35rem;
                white-space: nowrap;
            }

            .about-pill.green {
                background: rgba(16,185,129,0.16);
                color: #a7f3d0;
            }

            .about-pill.blue {
                background: rgba(56,189,248,0.16);
                color: #bae6fd;
            }

            @media (max-width: 900px) {
                .about-card {
                    grid-template-columns: 1fr;
                    gap: 1.2rem;
                    padding: 1.25rem 1.2rem;
                }

                .about-detail-list {
                    grid-template-columns: 1fr;
                }

                .about-detail {
                    padding: 1rem 1rem;
                }

                .about-pill {
                    font-size: 0.78rem;
                }
            }

            @media (max-width: 540px) {
                .about-card {
                    padding: 1rem 0.9rem;
                    border-radius: 18px;
                }

                .about-detail {
                    flex-direction: row;
                    gap: 0.75rem;
                }

                .about-left h3 {
                    font-size: 1.2rem;
                }
            }
        </style>

        <div class="card about-card">
            <div class="about-left">
                <h3>Sedikit Perkenalan</h3>
                <p class="muted">
                    <?php if (isset($biodata) && $biodata && !empty($biodata['tentang'])): ?>
                        <?= nl2br(esc($biodata['tentang'])) ?>
                    <?php else: ?>
                        Selamat datang di portfolio digital saya. Di sini Anda dapat melihat ringkasan pendidikan, pengalaman, dan aktivitas yang saya jalani sebagai pengembang maupun pribadi yang terus belajar.
                    <?php endif; ?>
                </p>
                <p class="muted muted-secondary">
                    Fokus saya adalah membangun solusi yang rapi, efisien, dan mudah dipakai, sambil tetap terbuka dengan teknologi baru dan kesempatan kolaborasi.
                </p>
            </div>

            <div class="about-detail-list">
                <div class="about-detail">
                    <div class="pill about-pill">
                        <i class="fas fa-rocket"></i> Tujuan
                    </div>
                    <p class="muted" style="margin: 0; color: #e5e7eb;">Terus berkembang lewat proyek baru, tantangan teknis, dan kolaborasi yang positif.</p>
                </div>

                <div class="about-detail">
                    <div class="pill about-pill green">
                        <i class="fas fa-heart"></i> Nilai
                    </div>
                    <p class="muted" style="margin: 0; color: #e5e7eb;">Konsisten, komunikatif, dan fokus pada hasil yang nyata untuk pengguna.</p>
                </div>

                <div class="about-detail">
                    <div class="pill about-pill blue">
                        <i class="fas fa-phone"></i> Hubungi
                    </div>
                    <p class="muted" style="margin: 0; color: #e5e7eb;">Siap berdiskusi tentang peluang baru atau proyek yang ingin Anda wujudkan.</p>
                </div>
            </div>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
