<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: linear-gradient(135deg, rgba(15,23,42,0.92), rgba(30,64,175,0.9));
        padding: 2rem;
        border-radius: 18px;
        margin-bottom: 2rem;
        box-shadow: 0 20px 55px rgba(0,0,0,0.35);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
        border: 1px solid rgba(148,163,184,0.4);
    }
    .admin-header h1 {
        color: #f8fafc;
        margin: 0;
    }
    .admin-header .btn {
        box-shadow: 0 10px 30px rgba(37,99,235,0.35);
    }
    .card {
        background: linear-gradient(135deg, rgba(15,23,42,0.94), rgba(30,64,175,0.9));
        border: 1px solid rgba(148,163,184,0.35);
        box-shadow: 0 22px 60px rgba(0,0,0,0.4);
    }
    .card label {
        color: #e5e7eb;
        font-weight: 600;
    }
    .form-control {
        background: rgba(15,23,42,0.9);
        color: #e5e7eb;
        border: 1px solid rgba(148,163,184,0.6);
        box-shadow: 0 10px 30px rgba(0,0,0,0.35);
    }
    .form-control::placeholder {
        color: #cbd5f5;
    }
    .form-control option {
        color: #0f172a;
        background: #e5e7eb;
    }
    .btn.submit-btn {
        padding: 10px 22px;
        background: linear-gradient(135deg, #2563eb, #0ea5e9);
        color: #f8fafc;
        border: none;
        border-radius: 12px;
        box-shadow: 0 10px 26px rgba(37,99,235,0.35);
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-plus"></i> Tambah Pendidikan</h1>
            <a href="<?= base_url('admin/pendidikan') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <form method="POST" action="<?= base_url('admin/pendidikan/create') ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Jenjang *</label>
                    <select name="jenjang" class="form-control" required>
                        <option value="">Pilih Jenjang</option>
                        <option value="SD">SD</option>
                        <option value="SMP">SMP</option>
                        <option value="SMA">SMA</option>
                        <option value="S1">S1</option>
                        <option value="S2">S2</option>
                        <option value="S3">S3</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Institusi *</label>
                    <input type="text" name="institusi" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label>Jurusan</label>
                    <input type="text" name="jurusan" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Tahun Mulai</label>
                    <input type="number" name="tahun_mulai" class="form-control" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Tahun Selesai</label>
                    <input type="number" name="tahun_selesai" class="form-control" min="1900" max="2100">
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="5"></textarea>
                </div>

                <div class="form-group">
                    <label>Foto Institusi (opsional)</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    <small style="margin-top: 0.35rem; color: #cbd5f5;">Unggah gambar logo/gedung kampus untuk ditampilkan di riwayat pendidikan.</small>
                </div>
                
                <button type="submit" class="btn submit-btn">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
