<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-edit"></i> Edit Aktivitas</h1>
            <a href="<?= base_url('admin/aktivitas') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <?php if ($aktivitas): ?>
            <form method="POST" action="<?= base_url('admin/aktivitas/edit/' . $aktivitas['id']) ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Nama Aktivitas *</label>
                    <input type="text" name="nama_aktivitas" class="form-control" value="<?= esc($aktivitas['nama_aktivitas']) ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" class="form-control" value="<?= esc($aktivitas['tanggal']) ?>">
                </div>
                
                <div class="form-group">
                    <label>Jam</label>
                    <input type="time" name="jam" class="form-control" value="<?= esc($aktivitas['jam']) ?>">
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="5"><?= esc($aktivitas['deskripsi']) ?></textarea>
                </div>
                
                <div class="form-group">
                    <label>Jenis *</label>
                    <select name="jenis" class="form-control" required>
                        <option value="">Pilih Jenis</option>
                        <option value="foto" <?= $aktivitas['jenis'] === 'foto' ? 'selected' : '' ?>>Foto</option>
                        <option value="video" <?= $aktivitas['jenis'] === 'video' ? 'selected' : '' ?>>Video</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>File Aktivitas (Foto / Video)</label>
                    <?php if (!empty($aktivitas['file_path'])): ?>
                        <p style="font-size: 0.9rem; color: #9ca3af; margin-bottom: 0.5rem;">File saat ini: <code><?= esc($aktivitas['file_path']) ?></code></p>
                    <?php endif; ?>
                    <input type="file" name="file_aktivitas" class="form-control" accept="image/*,video/*">
                    <small style="margin-top: 0.35rem; color: #9ca3af;">Kosongkan jika tidak ingin mengganti file.</small>
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-save"></i> Update
                </button>
            </form>
            <?php else: ?>
            <p>Data tidak ditemukan</p>
            <?php endif; ?>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
