<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateAktivitasTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'tanggal' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'jam' => [
                'type' => 'TIME',
                'null' => true,
            ],
            'nama_aktivitas' => [
                'type'       => 'VARCHAR',
                'constraint' => '200',
            ],
            'deskripsi' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'jenis' => [
                'type'       => 'ENUM',
                'constraint' => ['foto', 'video'],
                'null'       => true,
            ],
            'file_path' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('aktivitas');
    }

    public function down()
    {
        $this->forge->dropTable('aktivitas');
    }
}

