<?php
/**
 * Tailwind CSS Pagination Template
 */
$pager->setSurroundCount(2);
?>

<nav aria-label="<?= lang('Pager.pageNavigation') ?>">
    <ul class="flex items-center justify-center space-x-2">
        <?php if ($pager->hasPrevious()) : ?>
            <li>
                <a href="<?= $pager->getFirst() ?>" class="pagination-link flex items-center justify-center w-10 h-10 rounded-lg bg-white border border-slate-200 text-slate-500 hover:bg-slate-50 hover:text-sky-600 transition-colors shadow-sm" title="<?= lang('Pager.first') ?>">
                    <i class="fas fa-angle-double-left"></i>
                </a>
            </li>
            <li>
                <a href="<?= $pager->getPrevious() ?>" class="pagination-link flex items-center justify-center w-10 h-10 rounded-lg bg-white border border-slate-200 text-slate-500 hover:bg-slate-50 hover:text-sky-600 transition-colors shadow-sm" title="<?= lang('Pager.previous') ?>">
                    <i class="fas fa-angle-left"></i>
                </a>
            </li>
        <?php endif ?>

        <?php foreach ($pager->links() as $link) : ?>
            <li>
                <a href="<?= $link['uri'] ?>" 
                   class="pagination-link flex items-center justify-center w-10 h-10 rounded-lg transition-all <?= $link['active'] ? 'bg-gradient-to-r from-sky-500 to-blue-600 text-white font-bold shadow-md shadow-sky-500/30' : 'bg-white border border-slate-200 text-slate-500 hover:bg-slate-50 hover:text-sky-600 shadow-sm' ?>">
                    <?= $link['title'] ?>
                </a>
            </li>
        <?php endforeach ?>

        <?php if ($pager->hasNext()) : ?>
            <li>
                <a href="<?= $pager->getNext() ?>" class="pagination-link flex items-center justify-center w-10 h-10 rounded-lg bg-white border border-slate-200 text-slate-500 hover:bg-slate-50 hover:text-sky-600 transition-colors shadow-sm" title="<?= lang('Pager.next') ?>">
                    <i class="fas fa-angle-right"></i>
                </a>
            </li>
            <li>
                <a href="<?= $pager->getLast() ?>" class="pagination-link flex items-center justify-center w-10 h-10 rounded-lg bg-white border border-slate-200 text-slate-500 hover:bg-slate-50 hover:text-sky-600 transition-colors shadow-sm" title="<?= lang('Pager.last') ?>">
                    <i class="fas fa-angle-double-right"></i>
                </a>
            </li>
        <?php endif ?>
    </ul>
</nav>
