<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('content') ?>
<div class="min-h-screen py-12 bg-sky-50">
    <!-- Print Styles -->
    <style>
        @media print {
            nav, footer, .no-print, .fixed { display: none !important; }
            body { background: white !important; color: black !important; }
            .min-h-screen { min-height: auto !important; padding: 0 !important; }
            .max-w-7xl { max-width: 100% !important; padding: 0 !important; margin: 0 !important; }
            .bg-white, .bg-sky-50, .bg-slate-50 {
                background: white !important;
                box-shadow: none !important;
                border: 1px solid #eee !important;
            }
            .shadow-sm, .shadow-md, .shadow-xl { box-shadow: none !important; }
            /* Compact Spacing */
            .p-8 { padding: 1.5rem !important; }
            .mb-8 { margin-bottom: 1.5rem !important; }
            .gap-8 { gap: 1.5rem !important; }
            /* Prevent Breaks */
            .grid, .card-hover { break-inside: avoid; }
            /* Text Colors */
            .text-slate-800, .text-slate-600, .text-sky-600 { color: black !important; }
        }
    </style>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <?php if (!empty($biodata)): ?>
            
            <!-- Top Section: Photo (Left) & Info (Right) -->
            <div class="bg-white border border-sky-100 rounded-2xl p-8 mb-8 animate-fade-in shadow-sm">
                <div class="flex flex-col md:flex-row gap-8 items-start">
                    
                    <!-- Left: Photo -->
                    <div class="flex-shrink-0 w-full md:w-auto text-center md:text-left">
                        <?php if (!empty($biodata['foto'])): ?>
                            <div class="relative inline-block group">
                                <div class="absolute -inset-2 bg-gradient-to-r from-sky-400 to-blue-500 rounded-2xl blur-lg opacity-30 group-hover:opacity-50 transition duration-500"></div>
                                <img src="<?= base_url('assets/uploads/biodata/' . $biodata['foto']) ?>" 
                                     alt="<?= esc($biodata['nama_lengkap']) ?>"
                                     class="relative w-64 h-80 object-cover rounded-2xl border-4 border-white shadow-xl shadow-sky-500/20 mx-auto md:mx-0">
                            </div>
                        <?php else: ?>
                            <div class="relative inline-block">
                                <div class="w-64 h-80 rounded-2xl bg-gradient-to-br from-sky-100 to-blue-200 flex items-center justify-center border-4 border-white shadow-xl mx-auto md:mx-0">
                                    <i class="fas fa-user text-6xl text-sky-500/50"></i>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Right: About Me & Header Info -->
                    <div class="flex-1">
                        <div class="mb-6">
                            <h1 class="text-4xl md:text-5xl font-bold text-slate-800 mb-2"><?= esc($biodata['nama_lengkap']) ?></h1>
                            <p class="text-sky-600 text-xl font-medium">Mahasiswa</p>
                        </div>

                        <?php if (!empty($biodata['deskripsi_diri'])): ?>
                            <div class="bg-sky-50 rounded-xl p-6 border border-sky-100">
                                <h2 class="text-xl font-bold mb-4 flex items-center text-slate-800">
                                    <i class="fas fa-quote-left text-sky-400 mr-3"></i>
                                    Tentang Saya
                                </h2>
                                <p class="text-slate-600 leading-relaxed whitespace-pre-line text-justify"><?= esc($biodata['deskripsi_diri']) ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Middle Section: Personal Data Grid -->
            <div class="bg-white border border-sky-100 rounded-2xl overflow-hidden mb-8 animate-fade-in-up delay-100 shadow-sm">
                <div class="p-8">
                    <h2 class="text-xl font-bold mb-6 flex items-center text-slate-800">
                        <i class="fas fa-user-circle text-sky-500 mr-3"></i>
                        Informasi Personal
                    </h2>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <!-- Jenis Kelamin -->
                        <?php if (!empty($biodata['jenis_kelamin'])): ?>
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-pink-100 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-venus-mars text-pink-500"></i>
                            </div>
                            <div>
                                <p class="text-sm text-slate-500 mb-1">Jenis Kelamin</p>
                                <p class="text-slate-800 font-medium"><?= esc($biodata['jenis_kelamin']) ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Tempat, Tanggal Lahir -->
                        <?php if (!empty($biodata['tempat_lahir']) || !empty($biodata['tanggal_lahir'])): ?>
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-birthday-cake text-yellow-500"></i>
                            </div>
                            <div>
                                <p class="text-sm text-slate-500 mb-1">Tempat, Tanggal Lahir</p>
                                <p class="text-slate-800 font-medium">
                                    <?php 
                                    $ttl = [];
                                    if (!empty($biodata['tempat_lahir'])) $ttl[] = esc($biodata['tempat_lahir']);
                                    if (!empty($biodata['tanggal_lahir'])) {
                                        $date = new DateTime($biodata['tanggal_lahir']);
                                        $ttl[] = $date->format('d F Y');
                                    }
                                    echo implode(', ', $ttl);
                                    ?>
                                </p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Agama -->
                        <?php if (!empty($biodata['agama'])): ?>
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-pray text-purple-500"></i>
                            </div>
                            <div>
                                <p class="text-sm text-slate-500 mb-1">Agama</p>
                                <p class="text-slate-800 font-medium"><?= esc($biodata['agama']) ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Email -->
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-envelope text-blue-500"></i>
                            </div>
                            <div>
                                <p class="text-sm text-slate-500 mb-1">Email</p>
                                <p class="text-slate-800 font-medium"><?= esc($biodata['email']) ?></p>
                            </div>
                        </div>
                        
                        <!-- No. HP -->
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-emerald-100 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-phone text-emerald-500"></i>
                            </div>
                            <div>
                                <p class="text-sm text-slate-500 mb-1">No. HP</p>
                                <p class="text-slate-800 font-medium"><?= esc($biodata['no_hp']) ?></p>
                            </div>
                        </div>
                        
                        <!-- Alamat -->
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-rose-100 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-map-marker-alt text-rose-500"></i>
                            </div>
                            <div>
                                <p class="text-sm text-slate-500 mb-1">Alamat</p>
                                <p class="text-slate-800 font-medium"><?= esc($biodata['alamat']) ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom Section: Education Timeline -->
            <?php if (!empty($pendidikan)): ?>
                <div class="bg-white border border-sky-100 rounded-2xl overflow-hidden animate-fade-in-up delay-200 shadow-sm">
                    <div class="p-8">
                        <h2 class="text-xl font-bold mb-8 flex items-center text-slate-800">
                            <i class="fas fa-graduation-cap text-indigo-500 mr-3"></i>
                            Riwayat Pendidikan
                        </h2>
                        
                        <div class="timeline">
                            <?php foreach ($pendidikan as $edu): ?>
                                <div class="timeline-item">
                                    <div class="bg-slate-50 rounded-xl p-4 border border-slate-100 hover:border-sky-200 hover:bg-sky-50 transition-colors">
                                        <?php 
                                        $colors = [
                                            'SD' => 'text-green-600',
                                            'SMP' => 'text-blue-600',
                                            'SMA' => 'text-yellow-600',
                                            'Kuliah' => 'text-purple-600',
                                        ];
                                        $color = $colors[$edu['jenjang']] ?? 'text-slate-500';
                                        ?>
                                        <span class="<?= $color ?> font-bold text-sm"><?= $edu['jenjang'] ?></span>
                                        <h3 class="text-lg font-bold text-slate-800 mt-1"><?= esc($edu['nama_sekolah']) ?></h3>
                                        <p class="text-slate-500 text-sm mt-1">
                                            <?= $edu['tahun_masuk'] ?> - <?= $edu['tahun_lulus'] ?? 'Sekarang' ?>
                                            <?php if (!empty($edu['jurusan'])): ?>
                                                <span class="mx-2 text-slate-300">•</span> <span class="text-slate-600"><?= esc($edu['jurusan']) ?></span>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Print Button -->
            <div class="text-center mt-8 no-print">
                <button onclick="printPage()" class="btn-primary px-8 py-4 rounded-xl text-white font-medium inline-flex items-center shadow-lg shadow-sky-500/30">
                    <i class="fas fa-print mr-2"></i>
                    Cetak CV
                </button>
            </div>

        <?php else: ?>
            <div class="text-center py-20 bg-white border border-sky-100 rounded-2xl shadow-sm">
                <div class="w-20 h-20 bg-sky-50 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-user-slash text-3xl text-sky-300"></i>
                </div>
                <h3 class="text-xl font-medium text-slate-800 mb-2">Biodata Belum Tersedia</h3>
                <p class="text-slate-400">Data biodata belum ditambahkan</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>
