<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in max-w-3xl">
    <a href="<?= base_url('admin/biodata') ?>" class="inline-flex items-center text-slate-500 hover:text-slate-800 mb-6 transition-colors">
        <i class="fas fa-arrow-left mr-2"></i>Kembali
    </a>

    <div class="bg-white border border-slate-200 rounded-2xl p-6 shadow-sm">
        <h2 class="text-xl font-bold mb-6 flex items-center text-slate-800">
            <i class="fas fa-edit text-blue-600 mr-3"></i>Edit Biodata
        </h2>

        <form action="<?= base_url('admin/biodata/update/' . $biodata['id']) ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?= csrf_field() ?>

            <div>
                <label for="nama_lengkap" class="block text-sm font-medium text-slate-600 mb-2">Nama Lengkap <span class="text-red-500">*</span></label>
                <input type="text" id="nama_lengkap" name="nama_lengkap" value="<?= old('nama_lengkap') ?? $biodata['nama_lengkap'] ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm" required>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="jenis_kelamin" class="block text-sm font-medium text-slate-600 mb-2">Jenis Kelamin</label>
                    <?php $jk = old('jenis_kelamin') ?? ($biodata['jenis_kelamin'] ?? ''); ?>
                    <select id="jenis_kelamin" name="jenis_kelamin" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm">
                        <option value="">-- Pilih --</option>
                        <option value="Laki-laki" <?= $jk == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                        <option value="Perempuan" <?= $jk == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                    </select>
                </div>
                <div>
                    <label for="agama" class="block text-sm font-medium text-slate-600 mb-2">Agama</label>
                    <?php $agama = old('agama') ?? ($biodata['agama'] ?? ''); ?>
                    <select id="agama" name="agama" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm">
                        <option value="">-- Pilih --</option>
                        <option value="Islam" <?= $agama == 'Islam' ? 'selected' : '' ?>>Islam</option>
                        <option value="Kristen" <?= $agama == 'Kristen' ? 'selected' : '' ?>>Kristen</option>
                        <option value="Katolik" <?= $agama == 'Katolik' ? 'selected' : '' ?>>Katolik</option>
                        <option value="Hindu" <?= $agama == 'Hindu' ? 'selected' : '' ?>>Hindu</option>
                        <option value="Buddha" <?= $agama == 'Buddha' ? 'selected' : '' ?>>Buddha</option>
                        <option value="Konghucu" <?= $agama == 'Konghucu' ? 'selected' : '' ?>>Konghucu</option>
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="tempat_lahir" class="block text-sm font-medium text-slate-600 mb-2">Tempat Lahir</label>
                    <input type="text" id="tempat_lahir" name="tempat_lahir" value="<?= old('tempat_lahir') ?? ($biodata['tempat_lahir'] ?? '') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm" placeholder="Contoh: Jakarta">
                </div>
                <div>
                    <label for="tanggal_lahir" class="block text-sm font-medium text-slate-600 mb-2">Tanggal Lahir</label>
                    <input type="date" id="tanggal_lahir" name="tanggal_lahir" value="<?= old('tanggal_lahir') ?? ($biodata['tanggal_lahir'] ?? '') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm">
                </div>
            </div>

            <div>
                <label for="email" class="block text-sm font-medium text-slate-600 mb-2">Email <span class="text-red-500">*</span></label>
                <input type="email" id="email" name="email" value="<?= old('email') ?? $biodata['email'] ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm" required>
            </div>

            <div>
                <label for="no_hp" class="block text-sm font-medium text-slate-600 mb-2">No. HP <span class="text-red-500">*</span></label>
                <input type="text" id="no_hp" name="no_hp" value="<?= old('no_hp') ?? $biodata['no_hp'] ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm" required>
            </div>

            <div>
                <label for="alamat" class="block text-sm font-medium text-slate-600 mb-2">Alamat <span class="text-red-500">*</span></label>
                <textarea id="alamat" name="alamat" rows="3" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 resize-none focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm" required><?= old('alamat') ?? $biodata['alamat'] ?></textarea>
            </div>

            <div>
                <label for="deskripsi_diri" class="block text-sm font-medium text-slate-600 mb-2">Deskripsi Diri</label>
                <textarea id="deskripsi_diri" name="deskripsi_diri" rows="4" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 resize-none focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all shadow-sm"><?= old('deskripsi_diri') ?? $biodata['deskripsi_diri'] ?></textarea>
            </div>

            <?php if (!empty($biodata['foto'])): ?>
            <div class="bg-slate-50 rounded-lg p-4 border border-slate-200">
                <p class="text-sm text-slate-600 mb-2">Foto Saat Ini:</p>
                <div class="flex items-center space-x-4">
                    <img src="<?= base_url('assets/uploads/biodata/' . $biodata['foto']) ?>" alt="Foto" class="h-24 w-24 object-cover rounded-lg border border-slate-200 shadow-sm">
                    <label class="flex items-center space-x-2 text-red-500 cursor-pointer hover:text-red-600">
                        <input type="checkbox" name="hapus_foto" value="1" class="w-4 h-4 rounded border-slate-300 bg-white text-red-500 focus:ring-red-500">
                        <span class="text-sm"><i class="fas fa-trash mr-1"></i>Hapus foto ini</span>
                    </label>
                </div>
            </div>
            <?php endif; ?>

            <div>
                <label for="foto" class="block text-sm font-medium text-slate-600 mb-2">Ganti Foto</label>
                <input type="file" id="foto" name="foto" accept="image/*" onchange="previewImage(this, 'fotoPreview')" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-blue-100 file:text-blue-700 hover:file:bg-blue-200 cursor-pointer shadow-sm">
                <img id="fotoPreview" src="" alt="Preview" class="hidden mt-3 max-h-40 rounded-lg border border-slate-200 shadow-sm">
            </div>

            <div class="flex justify-end space-x-4 pt-4 border-t border-slate-100">
                <a href="<?= base_url('admin/biodata') ?>" class="px-6 py-3 bg-slate-100 rounded-lg text-slate-600 hover:bg-slate-200 transition-colors">Batal</a>
                <button type="submit" class="btn-primary px-6 py-3 rounded-lg text-white font-medium shadow-lg shadow-sky-500/30"><i class="fas fa-save mr-2"></i>Update</button>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
