<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
<div class="animate-fade-in max-w-3xl">
    <a href="<?= base_url('admin/biodata') ?>" class="inline-flex items-center text-slate-500 hover:text-slate-800 mb-6 transition-colors">
        <i class="fas fa-arrow-left mr-2"></i>Kembali
    </a>

    <div class="bg-white border border-slate-200 rounded-2xl p-6 shadow-sm">
        <h2 class="text-xl font-bold mb-6 flex items-center text-slate-800">
            <i class="fas fa-user-plus text-emerald-600 mr-3"></i>Tambah Biodata
        </h2>

        <form action="<?= base_url('admin/biodata/store') ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?= csrf_field() ?>

            <div>
                <label for="nama_lengkap" class="block text-sm font-medium text-slate-600 mb-2">Nama Lengkap <span class="text-red-500">*</span></label>
                <input type="text" id="nama_lengkap" name="nama_lengkap" value="<?= old('nama_lengkap') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm" required>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="jenis_kelamin" class="block text-sm font-medium text-slate-600 mb-2">Jenis Kelamin</label>
                    <select id="jenis_kelamin" name="jenis_kelamin" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm">
                        <option value="">-- Pilih --</option>
                        <option value="Laki-laki" <?= old('jenis_kelamin') == 'Laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                        <option value="Perempuan" <?= old('jenis_kelamin') == 'Perempuan' ? 'selected' : '' ?>>Perempuan</option>
                    </select>
                </div>
                <div>
                    <label for="agama" class="block text-sm font-medium text-slate-600 mb-2">Agama</label>
                    <select id="agama" name="agama" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm">
                        <option value="">-- Pilih --</option>
                        <option value="Islam" <?= old('agama') == 'Islam' ? 'selected' : '' ?>>Islam</option>
                        <option value="Kristen" <?= old('agama') == 'Kristen' ? 'selected' : '' ?>>Kristen</option>
                        <option value="Katolik" <?= old('agama') == 'Katolik' ? 'selected' : '' ?>>Katolik</option>
                        <option value="Hindu" <?= old('agama') == 'Hindu' ? 'selected' : '' ?>>Hindu</option>
                        <option value="Buddha" <?= old('agama') == 'Buddha' ? 'selected' : '' ?>>Buddha</option>
                        <option value="Konghucu" <?= old('agama') == 'Konghucu' ? 'selected' : '' ?>>Konghucu</option>
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label for="tempat_lahir" class="block text-sm font-medium text-slate-600 mb-2">Tempat Lahir</label>
                    <input type="text" id="tempat_lahir" name="tempat_lahir" value="<?= old('tempat_lahir') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm" placeholder="Contoh: Jakarta">
                </div>
                <div>
                    <label for="tanggal_lahir" class="block text-sm font-medium text-slate-600 mb-2">Tanggal Lahir</label>
                    <input type="date" id="tanggal_lahir" name="tanggal_lahir" value="<?= old('tanggal_lahir') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm">
                </div>
            </div>

            <div>
                <label for="email" class="block text-sm font-medium text-slate-600 mb-2">Email <span class="text-red-500">*</span></label>
                <input type="email" id="email" name="email" value="<?= old('email') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm" required>
            </div>

            <div>
                <label for="no_hp" class="block text-sm font-medium text-slate-600 mb-2">No. HP <span class="text-red-500">*</span></label>
                <input type="text" id="no_hp" name="no_hp" value="<?= old('no_hp') ?>" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm" required>
            </div>

            <div>
                <label for="alamat" class="block text-sm font-medium text-slate-600 mb-2">Alamat <span class="text-red-500">*</span></label>
                <textarea id="alamat" name="alamat" rows="3" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 resize-none focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm" required><?= old('alamat') ?></textarea>
            </div>

            <div>
                <label for="deskripsi_diri" class="block text-sm font-medium text-slate-600 mb-2">Deskripsi Diri</label>
                <textarea id="deskripsi_diri" name="deskripsi_diri" rows="4" class="form-input w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 resize-none focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all shadow-sm"><?= old('deskripsi_diri') ?></textarea>
            </div>

            <div>
                <label for="foto" class="block text-sm font-medium text-slate-600 mb-2">Foto</label>
                <input type="file" id="foto" name="foto" accept="image/*" onchange="previewImage(this, 'fotoPreview')" class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-lg text-slate-800 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-emerald-100 file:text-emerald-700 hover:file:bg-emerald-200 cursor-pointer shadow-sm">
                <img id="fotoPreview" src="" alt="Preview" class="hidden mt-3 max-h-40 rounded-lg border border-slate-200 shadow-sm">
            </div>

            <div class="flex justify-end space-x-4 pt-4 border-t border-slate-100">
                <a href="<?= base_url('admin/biodata') ?>" class="px-6 py-3 bg-slate-100 rounded-lg text-slate-600 hover:bg-slate-200 transition-colors">Batal</a>
                <button type="submit" class="btn-primary px-6 py-3 rounded-lg text-white font-medium shadow-lg shadow-sky-500/30"><i class="fas fa-save mr-2"></i>Simpan</button>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
