<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddIsActiveToBiodata extends Migration
{
    public function up()
    {
        $this->forge->addColumn('biodata', [
            'is_active' => [
                'type'       => 'TINYINT',
                'constraint' => 1,
                'default'    => 0,
                'after'      => 'foto'
            ],
        ]);
        
        // Set the first record as active by default if exists
        $db = \Config\Database::connect();
        $builder = $db->table('biodata');
        $first = $builder->limit(1)->orderBy('id', 'ASC')->get()->getRow();
        if ($first) {
            $builder->where('id', $first->id)->update(['is_active' => 1]);
        }
    }

    public function down()
    {
        $this->forge->dropColumn('biodata', 'is_active');
    }
}
