<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;
use App\Models\BiodataModel;
use App\Models\RiwayatPendidikanModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $aktivitasModel = new AktivitasModel();
        $biodataModel = new BiodataModel();
        $pendidikanModel = new RiwayatPendidikanModel();

        $data = [
            'title' => 'Dashboard',
            'totalAktivitas' => $aktivitasModel->countAll(),
            'totalBiodata' => $biodataModel->countAll(),
            'totalPendidikan' => $pendidikanModel->countAll(),
            'recentAktivitas' => $aktivitasModel->orderBy('created_at', 'DESC')->limit(5)->findAll(),
        ];

        return view('admin/dashboard', $data);
    }
}
