<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<?php
    $search      = $search ?? '';
    $filterField = $filterField ?? '';
    $filterValue = $filterValue ?? '';
    $sortBy      = $sortBy ?? 'tahun_selesai';
    $sortDir     = $sortDir ?? 'desc';
    $pageParam   = $pageParam ?? 'page_pendidikan';
    $perPage     = $perPage ?? 10;
    $totalRows   = isset($pager) ? $pager->getTotal('pendidikan') : count($pendidikan ?? []);
?>

<section style="padding-top: 100px;">
    <div class="container">
        <h2 class="section-title">Riwayat Pendidikan</h2>

        <div class="filter-section">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label for="search-pendidikan">Pencarian</label>
                    <input id="search-pendidikan" type="text" name="search" class="form-control" placeholder="Cari jenjang, institusi, jurusan..." value="<?= esc($search) ?>">
                </div>
                <div class="form-group">
                    <label for="filter-field">Filter kolom</label>
                    <select id="filter-field" name="filter_field" class="form-control">
                        <option value="">Semua kolom</option>
                        <option value="jenjang" <?= $filterField === 'jenjang' ? 'selected' : '' ?>>Jenjang</option>
                        <option value="institusi" <?= $filterField === 'institusi' ? 'selected' : '' ?>>Institusi</option>
                        <option value="jurusan" <?= $filterField === 'jurusan' ? 'selected' : '' ?>>Jurusan</option>
                        <option value="tahun_mulai" <?= $filterField === 'tahun_mulai' ? 'selected' : '' ?>>Tahun Mulai</option>
                        <option value="tahun_selesai" <?= $filterField === 'tahun_selesai' ? 'selected' : '' ?>>Tahun Selesai</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="filter-value">Nilai filter</label>
                    <input id="filter-value" type="text" name="filter_value" class="form-control" placeholder="Misal: S1, Universitas, 2022" value="<?= esc($filterValue) ?>">
                </div>
                <div class="form-group">
                    <label for="sort-by">Urutkan</label>
                    <select id="sort-by" name="sort_by" class="form-control">
                        <option value="id" <?= $sortBy === 'id' ? 'selected' : '' ?>>ID</option>
                        <option value="jenjang" <?= $sortBy === 'jenjang' ? 'selected' : '' ?>>Jenjang</option>
                        <option value="institusi" <?= $sortBy === 'institusi' ? 'selected' : '' ?>>Institusi</option>
                        <option value="jurusan" <?= $sortBy === 'jurusan' ? 'selected' : '' ?>>Jurusan</option>
                        <option value="tahun_mulai" <?= $sortBy === 'tahun_mulai' ? 'selected' : '' ?>>Tahun Mulai</option>
                        <option value="tahun_selesai" <?= $sortBy === 'tahun_selesai' ? 'selected' : '' ?>>Tahun Selesai</option>
                        <option value="created_at" <?= $sortBy === 'created_at' ? 'selected' : '' ?>>Tanggal dibuat</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="sort-dir">Arah urutan</label>
                    <select id="sort-dir" name="sort_dir" class="form-control">
                        <option value="asc" <?= $sortDir === 'asc' ? 'selected' : '' ?>>Naik (A-Z / 0-9)</option>
                        <option value="desc" <?= $sortDir === 'desc' ? 'selected' : '' ?>>Turun (Z-A / 9-0)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>&nbsp;</label>
                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                        <button type="submit" class="btn" style="padding: 10px 20px;">Terapkan</button>
                        <a href="<?= current_url() ?>" class="btn secondary" style="padding: 10px 20px;">Reset</a>
                    </div>
                </div>
            </form>
            <div class="muted" style="margin-top: 0.5rem;">
                Data publik hanya dapat dibaca. Menampilkan <?= count($pendidikan ?? []) ?> dari <?= $totalRows ?> catatan (<?= $perPage ?> per halaman).
            </div>
        </div>

        <?php if (!empty($pendidikan)): ?>
        <div style="display: grid; gap: 1.5rem;">
            <?php foreach ($pendidikan as $item): ?>
            <div class="card">
                <div style="display: grid; grid-template-columns: 140px 1fr; gap: 1rem; align-items: center;">
                    <div style="width: 140px; height: 140px; border-radius: 14px; overflow: hidden; background: linear-gradient(135deg,#e2e8f0,#cbd5e1); display:flex; align-items:center; justify-content:center;">
                        <?php if (!empty($item['foto'])): ?>
                            <img src="<?= base_url(esc($item['foto'])) ?>" alt="<?= esc($item['institusi']) ?>" style="width: 100%; height: 100%; object-fit: cover;">
                        <?php else: ?>
                            <i class="fas fa-school" style="font-size: 2.5rem; color: #94a3b8;"></i>
                        <?php endif; ?>
                    </div>
                    <div>
                        <div class="pill" style="margin-bottom: 0.35rem;"><?= esc($item['jenjang']) ?></div>
                        <p style="font-size: 1.1rem; font-weight: 600; margin-bottom: 0.5rem;"><?= esc($item['institusi']) ?></p>
                        <?php if (!empty($item['jurusan']) && $item['jurusan'] !== '-'): ?>
                        <p style="color: #64748b; margin-bottom: 0.5rem;"><i class="fas fa-graduation-cap"></i> <?= esc($item['jurusan']) ?></p>
                        <?php endif; ?>
                        <?php if (!empty($item['tahun_mulai']) && !empty($item['tahun_selesai'])): ?>
                        <p style="color: #64748b;"><i class="fas fa-calendar"></i> <?= esc($item['tahun_mulai']) ?> - <?= esc($item['tahun_selesai']) ?></p>
                        <?php endif; ?>
                        <?php if (!empty($item['deskripsi'])): ?>
                        <p style="margin-top: 1rem; color: #64748b;"><?= nl2br(esc($item['deskripsi'])) ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php else: ?>
        <div class="empty-state">
            <p>Data pendidikan belum tersedia.</p>
        </div>
        <?php endif; ?>

        <?php if (isset($pager)): ?>
        <div class="pagination">
            <?= $pager->links('pendidikan', 'default_full') ?>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
