<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<?php
    $nama         = $biodata['nama']   ?? 'Profesional Digital';
    $email        = $biodata['email']  ?? 'email@domain.com';
    $telepon      = $biodata['telepon'] ?? '';
    $alamat       = $biodata['alamat'] ?? '';
    $tagline      = $biodata['tentang'] ?? 'Membangun pengalaman digital yang berkelas dengan fokus pada detail dan hasil.';
    $fotoPath     = !empty($biodata['foto']) ? base_url(esc($biodata['foto'])) : '';
    $skills       = [];
    if (!empty($biodata['keahlian'])) {
        $skills = array_filter(array_map('trim', preg_split('/[,\\n]+/', $biodata['keahlian'])));
    }
    $pendCount    = $pendidikanCount ?? 0;
    $aktivCount   = $aktivitasCount ?? 0;
?>

<style>
    .hero-pro {
        position: relative;
        padding: 140px 0 120px;
        overflow: hidden;
    }
    .hero-pro::before,
    .hero-pro::after {
        content: '';
        position: absolute;
        border-radius: 50%;
        filter: blur(80px);
        opacity: 0.35;
    }
    .hero-pro::before {
        width: 360px; height: 360px;
        background: #7c3aed;
        top: -80px; right: 10%;
    }
    .hero-pro::after {
        width: 420px; height: 420px;
        background: #06b6d4;
        bottom: -120px; left: -60px;
    }
    .hero-grid {
        position: relative;
        z-index: 1;
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
        gap: 32px;
        align-items: center;
    }
    .photo-3d {
        position: relative;
        width: 100%;
        max-width: 420px;
        margin: 0 auto;
        perspective: 1200px;
    }
    .cube-wrapper {
        --cube-size: clamp(220px, 32vw, 420px);
        --cube-half: calc(var(--cube-size) / 2);
        position: relative;
        width: 100%;
        max-width: var(--cube-size);
        margin: 0 auto;
        aspect-ratio: 1 / 1;
        perspective: 1200px;
    }
    .cube {
        position: absolute;
        width: var(--cube-size);
        height: var(--cube-size);
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        transform-style: preserve-3d;
        animation: cubeSpin 18s infinite linear;
    }
    .cube:hover { animation-play-state: paused; }
    .cube-face {
        position: absolute;
        width: 100%;
        height: 100%;
        border-radius: 18px;
        overflow: hidden;
        backface-visibility: hidden;
        background-size: cover;
        background-position: center;
        border: 2px solid rgba(255,255,255,0.35);
        box-shadow: inset 0 0 0 1px rgba(0,0,0,0.06), 0 20px 50px rgba(0,0,0,0.18);
    }
    .cube-face::after {
        content: '';
        position: absolute;
        inset: 0;
        background: linear-gradient(135deg, rgba(255,255,255,0.08), rgba(255,255,255,0));
    }
    .cube-face.front  { transform: translateZ(var(--cube-half)); }
    .cube-face.back   { transform: rotateY(180deg) translateZ(var(--cube-half)); }
    .cube-face.right  { transform: rotateY(90deg) translateZ(var(--cube-half)); }
    .cube-face.left   { transform: rotateY(-90deg) translateZ(var(--cube-half)); }
    .cube-face.top    { transform: rotateX(90deg) translateZ(var(--cube-half)); }
    .cube-face.bottom { transform: rotateX(-90deg) translateZ(var(--cube-half)); }
    .cube-shadow {
        position: absolute;
        width: 70%;
        height: 14%;
        background: radial-gradient(closest-side, rgba(0,0,0,0.25), rgba(0,0,0,0));
        bottom: -6%;
        left: 15%;
        filter: blur(10px);
        z-index: 0;
    }
    @keyframes cubeSpin {
        0%   { transform: translate(-50%, -50%) rotateX(-18deg) rotateY(18deg); }
        50%  { transform: translate(-50%, -50%) rotateX(24deg) rotateY(198deg); }
        100% { transform: translate(-50%, -50%) rotateX(342deg) rotateY(378deg); }
    }
    .chip-row {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
        margin-top: 16px;
    }
    .clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .read-more {
        margin-left: 8px;
        font-weight: 700;
        color: var(--primary-color);
        text-decoration: none;
    }
    .read-more:hover { text-decoration: underline; }
    .chip {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 12px;
        border-radius: 999px;
        background: rgba(255,255,255,0.6);
        border: 1px solid #e2e8f0;
        font-weight: 600;
        color: #1e293b;
        box-shadow: 0 4px 16px rgba(0,0,0,0.06);
    }
    .stat-card {
        background: white;
        padding: 16px;
        border-radius: 16px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    }
    .stat-card h3 {
        margin: 0;
        font-size: 2rem;
        color: var(--primary-color);
    }
    .section-slim {
        padding: 60px 0 40px;
    }
    .activity-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.2rem;
    }
    .activity-card {
        position: relative;
        background: linear-gradient(145deg, rgba(255,255,255,0.96), rgba(255,255,255,0.9));
        border-radius: 18px;
        overflow: hidden;
        border: 1px solid rgba(14,165,233,0.14);
        box-shadow: 0 18px 42px rgba(15,23,42,0.12);
        transition: transform 0.25s ease, box-shadow 0.25s ease;
    }
    .activity-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 22px 48px rgba(14,165,233,0.2);
    }
    .activity-thumb {
        width: 100%;
        height: 200px;
        object-fit: cover;
        display: block;
    }
    .activity-body {
        padding: 14px 14px 16px;
        display: grid;
        gap: 10px;
    }
    .activity-meta {
        display: flex;
        align-items: center;
        gap: 12px;
        flex-wrap: wrap;
        color: #475569;
        font-size: 0.95rem;
    }
    .activity-kind {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 8px 12px;
        border-radius: 999px;
        background: #eef2ff;
        color: #4338ca;
        font-weight: 700;
        width: fit-content;
    }
    .activity-title {
        margin: 0;
        font-size: 1.05rem;
        color: #0f172a;
    }
    .activity-overlay {
        position: absolute;
        inset: 0;
        background: linear-gradient(180deg, rgba(0,0,0,0) 0%, rgba(0,0,0,0.12) 65%, rgba(0,0,0,0.18) 100%);
        pointer-events: none;
    }

    /* About section */
    .about-shell {
        position: relative;
        background: linear-gradient(135deg, rgba(14,165,233,0.12), rgba(249,115,22,0.10));
        border: 1px solid rgba(14,165,233,0.14);
        box-shadow: 0 18px 46px rgba(15,23,42,0.14);
        border-radius: 20px;
        padding: 26px;
        overflow: hidden;
    }
    .about-shell::before {
        content: '';
        position: absolute;
        top: -20%;
        right: -10%;
        width: 40%;
        height: 140%;
        background: radial-gradient(circle, rgba(255,255,255,0.32), rgba(255,255,255,0));
        transform: rotate(22deg);
        filter: blur(12px);
        opacity: 0.9;
    }
    .about-grid {
        position: relative;
        z-index: 1;
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 18px;
        align-items: center;
    }
    .about-meta {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        margin: 12px 0 14px;
    }
    .about-meta .pill {
        background: rgba(255,255,255,0.7);
        border: 1px solid rgba(14,165,233,0.16);
        color: #0f172a;
    }
    .about-actions {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
        align-items: center;
    }
    .about-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 10px;
    }
    .about-stat-card {
        background: rgba(255,255,255,0.92);
        border: 1px solid rgba(14,165,233,0.12);
        padding: 14px;
        border-radius: 14px;
        box-shadow: 0 10px 24px rgba(15,23,42,0.12);
    }
    .about-stat-card h4 {
        margin: 6px 0 4px;
        font-size: 1.2rem;
        color: var(--primary-color);
    }
    .about-stat-card p {
        margin: 0;
        color: #475569;
        font-size: 0.95rem;
    }
    @media(max-width: 992px) {
        .about-grid {
            grid-template-columns: 1fr;
        }
        .about-actions {
            justify-content: flex-start;
        }
    }
    @media(max-width: 768px) {
        .hero-pro { padding-top: 120px; }
        .photo-3d { max-width: 100%; }
    }
</style>

<!-- Hero -->
<section class="hero-pro">
    <div class="container">
        <div class="hero-grid">
            <div>
                <div class="tagline"><i class="fas fa-sparkles"></i> Portfolio Digital</div>
                <h1 style="margin: 12px 0 8px; font-size: clamp(2rem, 4vw, 3.2rem); line-height: 1.1;">
                    <?= esc($nama) ?>
                </h1>
                <p class="muted clamp-2" style="font-size: 1.05rem; max-width: 640px;"><?= esc($tagline) ?> <a href="<?= base_url('cv') ?>" class="read-more">Baca selengkapnya</a></p>
                <div class="chip-row">
                    <?php if ($email): ?><span class="chip"><i class="fas fa-envelope"></i><?= esc($email) ?></span><?php endif; ?>
                    <?php if ($telepon): ?><span class="chip"><i class="fas fa-phone"></i><?= esc($telepon) ?></span><?php endif; ?>
                    <?php if ($alamat): ?><span class="chip"><i class="fas fa-location-dot"></i><?= esc($alamat) ?></span><?php endif; ?>
                </div>
                <div style="display: flex; gap: 12px; flex-wrap: wrap; margin-top: 18px;">
                    <a href="<?= base_url('cv') ?>" class="btn">Lihat CV</a>
                    <a href="<?= base_url('aktivitas') ?>" class="btn secondary">Lihat Aktivitas</a>
                </div>
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(160px, 1fr)); gap: 12px; margin-top: 22px;">
                    <div class="stat-card">
                        <div class="pill" style="background:#eef2ff; color:#4338ca; border:none;"><i class="fas fa-graduation-cap"></i> Pendidikan</div>
                        <h3><?= esc($pendCount) ?></h3>
                        <p class="muted" style="margin:0;">Rekam jejak akademik</p>
                    </div>
                    <div class="stat-card">
                        <div class="pill" style="background:#ecfeff; color:#0ea5e9; border:none;"><i class="fas fa-bolt"></i> Aktivitas</div>
                        <h3><?= esc($aktivCount) ?></h3>
                        <p class="muted" style="margin:0;">Karya & dokumentasi</p>
                    </div>
                </div>
            </div>
            <div class="photo-3d">
                <div class="cube-wrapper">
                    <div class="cube">
                        <?php
                            $texture = $fotoPath ?: '';
                            $bgStyle = $texture
                                ? 'background-image:url(' . $texture . ');'
                                : 'background-image:linear-gradient(135deg,#2563eb,#7c3aed);';
                        ?>
                        <div class="cube-face front"  style="<?= $bgStyle ?>"></div>
                        <div class="cube-face back"   style="<?= $bgStyle ?>"></div>
                        <div class="cube-face right"  style="<?= $bgStyle ?>"></div>
                        <div class="cube-face left"   style="<?= $bgStyle ?>"></div>
                        <div class="cube-face top"    style="<?= $bgStyle ?>"></div>
                        <div class="cube-face bottom" style="<?= $bgStyle ?>"></div>
                    </div>
                    <div class="cube-shadow"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Highlighted skills and short intro -->
<section class="section-slim" id="about">
    <div class="container">
        <div class="about-shell">
            <div class="about-grid">
                <div>
                    <div class="tagline" style="background:rgba(255,255,255,0.3); color:var(--dark-color);">
                        <i class="fas fa-user-astronaut"></i> Sekilas Tentang Saya
                    </div>
                    <h2 style="margin:6px 0 8px; font-size:1.5rem; color:var(--dark-color);">Profil Singkat</h2>
                    <p class="muted" style="margin:0; line-height:1.7;">
                        <?= esc($biodata['tentang'] ?? 'Berfokus pada pembangunan solusi digital yang berdampak, dengan pendekatan kolaboratif dan perhatian pada detail.') ?>
                    </p>
                    <?php if (!empty($skills)): ?>
                    <div class="about-meta">
                        <?php foreach ($skills as $skill): ?>
                            <span class="pill"><i class="fas fa-circle" style="font-size:0.6rem;"></i> <?= esc($skill) ?></span>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                    <div class="about-actions">
                        <a href="<?= base_url('cv') ?>" class="btn" style="padding: 11px 22px;">Lihat CV Lengkap</a>
                        <a href="<?= base_url('aktivitas') ?>" class="btn secondary" style="padding: 11px 22px;">Lihat Aktivitas</a>
                    </div>
                </div>
                <div class="about-stats">
                    <div class="about-stat-card">
                        <div class="pill" style="background:#ecfeff; color:#0ea5e9; border:none;">
                            <i class="fas fa-rocket"></i> Pengalaman
                        </div>
                        <h4><?= esc($pendCount) ?>+ Tahun</h4>
                        <p>Terlibat dalam proyek dan studi.</p>
                    </div>
                    <div class="about-stat-card">
                        <div class="pill" style="background:#fff7ed; color:#f97316; border:none;">
                            <i class="fas fa-layer-group"></i> Portofolio
                        </div>
                        <h4><?= esc($aktivCount) ?> Karya</h4>
                        <p>Foto, video, dan dokumentasi aktivitas.</p>
                    </div>
                    <div class="about-stat-card">
                        <div class="pill" style="background:#e0f2fe; color:#1d4ed8; border:none;">
                            <i class="fas fa-graduation-cap"></i> Pendidikan
                        </div>
                        <h4><?= esc($pendCount) ?> Catatan</h4>
                        <p>Jejak akademik yang tersusun.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Latest aktivitas -->
<section class="section-slim">
    <div class="container">
        <div style="display:flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 10px; margin-bottom: 16px;">
            <h3 style="margin:0;">Sorotan Aktivitas Terbaru</h3>
            <a href="<?= base_url('aktivitas') ?>" class="btn secondary" style="padding: 10px 20px;">Lihat Semua</a>
        </div>
        <?php if (!empty($latestAktivitas)): ?>
        <div class="activity-grid">
            <?php foreach ($latestAktivitas as $act): ?>
            <?php
                $mediaFiles = $act['media_files'] ?? [];
                if (empty($mediaFiles) && !empty($act['file_path'])) {
                    $decoded = json_decode($act['file_path'], true);
                    if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                        $mediaFiles = array_values(array_filter($decoded));
                    } elseif (!empty($act['file_path'])) {
                        $mediaFiles = [$act['file_path']];
                    }
                }
                $coverPath = $mediaFiles[0] ?? ($act['file_path'] ?? null);
            ?>
            <a class="activity-card" href="<?= base_url('aktivitas/' . $act['id']) ?>" style="text-decoration:none; color:inherit;">
                <?php if ($act['jenis'] === 'foto' && !empty($coverPath)): ?>
                    <img class="activity-thumb" src="<?= base_url(esc($coverPath)) ?>" alt="<?= esc($act['nama_aktivitas']) ?>">
                <?php elseif ($act['jenis'] === 'video' && !empty($coverPath)): ?>
                    <video class="activity-thumb" muted>
                        <source src="<?= base_url(esc($coverPath)) ?>" type="video/mp4">
                    </video>
                <?php else: ?>
                    <div class="activity-thumb" style="background: linear-gradient(135deg,#2563eb,#7c3aed); display:flex; align-items:center; justify-content:center; color:white; font-size:2rem;">
                        <i class="fas fa-<?= $act['jenis'] === 'foto' ? 'image' : 'video' ?>"></i>
                    </div>
                <?php endif; ?>
                <div class="activity-body">
                    <div class="activity-kind">
                        <i class="fas fa-<?= $act['jenis'] === 'foto' ? 'image' : 'video' ?>"></i> <?= ucfirst(esc($act['jenis'])) ?>
                    </div>
                    <h4 class="activity-title"><?= esc($act['nama_aktivitas']) ?></h4>
                    <?php if (!empty($act['tanggal'])): ?>
                        <div class="activity-meta">
                            <span><i class="fas fa-calendar"></i> <?= date('d M Y', strtotime($act['tanggal'])) ?></span>
                            <?php if (!empty($act['jam'])): ?>
                                <span><i class="fas fa-clock"></i> <?= date('H:i', strtotime($act['jam'])) ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="activity-overlay"></div>
            </a>
            <?php endforeach; ?>
        </div>
        <?php else: ?>
            <p class="muted">Belum ada aktivitas yang ditampilkan.</p>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
