<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<?php
    $isFoto = ($aktivitas['jenis'] === 'foto');
    $mediaFiles = $aktivitas['media_files'] ?? [];
    if ($isFoto && empty($mediaFiles) && !empty($aktivitas['file_path'])) {
        $decoded = json_decode($aktivitas['file_path'], true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
            $mediaFiles = array_values(array_filter($decoded));
        } elseif (!empty($aktivitas['file_path'])) {
            $mediaFiles = [$aktivitas['file_path']];
        }
    }
    $cover = $mediaFiles[0] ?? ($aktivitas['file_path'] ?? null);
?>
<style>
    .media-shell {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(340px, 1fr));
        gap: 2rem;
        align-items: start;
    }
    .gallery-stack { display: grid; gap: 16px; }
    .hero-photo {
        position: relative;
        border-radius: 18px;
        overflow: hidden;
        box-shadow: 0 18px 40px rgba(15,23,42,0.16);
        background: linear-gradient(145deg, rgba(255,255,255,0.9), rgba(226,232,240,0.9));
        border: 1px solid rgba(226,232,240,0.9);
        aspect-ratio: 4 / 3;
    }
    .hero-photo img,
    .hero-photo video {
        position: absolute;
        inset: 0;
        width: 100%;
        height: 100%;
        object-fit: contain;
        background: white;
    }
    .media-badge {
        position: absolute;
        top: 12px;
        right: 12px;
        padding: 8px 12px;
        border-radius: 12px;
        background: rgba(15,23,42,0.82);
        color: #e2e8f0;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        font-weight: 700;
        box-shadow: 0 10px 24px rgba(15,23,42,0.22);
    }
    .thumb-strip {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }
    .thumb-btn {
        position: relative;
        width: 96px;
        height: 72px;
        border-radius: 12px;
        overflow: hidden;
        border: 2px solid transparent;
        background: #fff;
        box-shadow: 0 8px 22px rgba(15,23,42,0.12);
        cursor: pointer;
        transition: transform 0.15s ease, border-color 0.15s ease, box-shadow 0.15s ease;
    }
    .thumb-btn img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        background: #fff;
        display: block;
    }
    .thumb-btn.active {
        border-color: var(--primary-color);
        box-shadow: 0 10px 26px rgba(14,165,233,0.24);
        transform: translateY(-2px);
    }
    .thumb-btn:hover { transform: translateY(-2px); }
    .detail-panel .pill {
        margin-bottom: 1rem;
    }
    @media (max-width: 640px) {
        .media-shell {
            grid-template-columns: 1fr;
        }
        .hero-photo { aspect-ratio: 1 / 1; }
        .thumb-strip { overflow-x: auto; padding-bottom: 6px; }
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <h2 class="section-title" style="margin-bottom: 2rem;"><?= esc($aktivitas['nama_aktivitas']) ?></h2>

        <div class="card media-shell">
            <div class="gallery-stack">
                <?php if ($isFoto && !empty($mediaFiles)): ?>
                    <div class="hero-photo" id="hero-photo">
                        <img src="<?= base_url(esc($cover)) ?>" alt="<?= esc($aktivitas['nama_aktivitas']) ?>" id="hero-img">
                        <div class="media-badge">
                            <i class="fas fa-images"></i> <?= count($mediaFiles) ?> Foto
                        </div>
                    </div>
                    <?php if (count($mediaFiles) > 1): ?>
                    <div class="thumb-strip" id="thumb-strip">
                        <?php foreach ($mediaFiles as $idx => $photo): ?>
                            <button type="button" class="thumb-btn <?= $idx === 0 ? 'active' : '' ?>" data-src="<?= base_url(esc($photo)) ?>">
                                <img src="<?= base_url(esc($photo)) ?>" alt="Foto <?= $idx + 1 ?>">
                            </button>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                <?php elseif ($aktivitas['jenis'] === 'video' && !empty($cover)): ?>
                    <div class="hero-photo">
                        <video controls>
                            <source src="<?= base_url(esc($cover)) ?>" type="video/mp4">
                            Browser Anda tidak mendukung video tag.
                        </video>
                        <div class="media-badge">
                            <i class="fas fa-video"></i> Video
                        </div>
                    </div>
                <?php else: ?>
                    <div style="width: 100%; height: 280px; background: var(--gradient); display: flex; align-items: center; justify-content: center; color: white; font-size: 3rem; border-radius: 16px;">
                        <i class="fas fa-<?= $aktivitas['jenis'] === 'foto' ? 'image' : 'video' ?>"></i>
                    </div>
                <?php endif; ?>
            </div>

            <div class="detail-panel">
                <div class="pill">
                    <i class="fas fa-<?= $aktivitas['jenis'] === 'foto' ? 'image' : 'video' ?>"></i>
                    <?= ucfirst(esc($aktivitas['jenis'])) ?>
                </div>

                <?php if (!empty($aktivitas['tanggal'])): ?>
                    <p style="margin-bottom: 0.5rem;"><strong>Tanggal:</strong> <?= date('d F Y', strtotime($aktivitas['tanggal'])) ?></p>
                <?php endif; ?>
                <?php if (!empty($aktivitas['jam'])): ?>
                    <p style="margin-bottom: 0.5rem;"><strong>Jam:</strong> <?= date('H:i', strtotime($aktivitas['jam'])) ?></p>
                <?php endif; ?>

                <?php if (!empty($aktivitas['deskripsi'])): ?>
                    <div style="margin-top: 1rem;">
                        <h4 style="margin-bottom: 0.5rem; color: var(--primary-color);">Deskripsi</h4>
                        <p><?= nl2br(esc($aktivitas['deskripsi'])) ?></p>
                    </div>
                <?php endif; ?>

                <div style="margin-top: 1.5rem;">
                    <a href="<?= base_url('aktivitas') ?>" class="btn secondary" style="padding: 10px 20px;">Kembali ke daftar</a>
                </div>
            </div>
        </div>
    </div>
</section>
<?php if ($isFoto && !empty($mediaFiles)): ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const heroImg   = document.getElementById('hero-img');
    const thumbBtns = Array.from(document.querySelectorAll('.thumb-btn'));
    if (!heroImg || !thumbBtns.length) return;

    thumbBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            const src = btn.getAttribute('data-src');
            if (!src) return;
            heroImg.src = src;
            thumbBtns.forEach(b => b.classList.remove('active'));
            btn.classList.add('active');
        });
    });
});
</script>
<?php endif; ?>
<?= $this->endSection() ?>
