<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
    .alert-success {
        background: #d1fae5;
        color: #065f46;
        padding: 1rem;
        border-radius: 10px;
        margin-bottom: 1rem;
        border: 1px solid #a7f3d0;
    }
</style>

<?php
    $search      = $search ?? '';
    $filterField = $filterField ?? '';
    $filterValue = $filterValue ?? '';
    $sortBy      = $sortBy ?? 'tahun_selesai';
    $sortDir     = $sortDir ?? 'desc';
    $pageParam   = $pageParam ?? 'page_pendidikan';

    $buildSortUrl = function (string $column) use ($search, $filterField, $filterValue, $sortBy, $sortDir, $pageParam) {
        $direction = ($sortBy === $column && $sortDir === 'asc') ? 'desc' : 'asc';
        $params    = array_filter([
            'search'       => $search,
            'filter_field' => $filterField,
            'filter_value' => $filterValue,
            'sort_by'      => $column,
            'sort_dir'     => $direction,
            $pageParam     => 1,
        ], 'strlen');

        return current_url() . '?' . http_build_query($params);
    };

    $sortIcon = function (string $column) use ($sortBy, $sortDir) {
        if ($sortBy !== $column) {
            return '<i class="fas fa-sort" aria-hidden="true"></i>';
        }

        return $sortDir === 'asc'
            ? '<i class="fas fa-arrow-up" aria-hidden="true"></i>'
            : '<i class="fas fa-arrow-down" aria-hidden="true"></i>';
    };

    $totalRows = isset($pager) ? $pager->getTotal('pendidikan') : count($pendidikan ?? []);
?>

<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-graduation-cap"></i> Kelola Pendidikan</h1>
            <div>
                <a href="<?= base_url('admin') ?>" class="btn" style="padding: 10px 20px; margin-right: 10px;">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
                <a href="<?= base_url('admin/pendidikan/create') ?>" class="btn" style="padding: 10px 20px;">
                    <i class="fas fa-plus"></i> Tambah Pendidikan
                </a>
            </div>
        </div>

        <?php if (session()->getFlashdata('success')): ?>
        <div class="alert-success">
            <i class="fas fa-check-circle"></i> <?= session()->getFlashdata('success') ?>
        </div>
        <?php endif; ?>

        <div class="filter-section">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label for="search-pendidikan">Pencarian</label>
                    <input id="search-pendidikan" type="text" name="search" class="form-control" placeholder="Cari jenjang, institusi, jurusan..." value="<?= esc($search) ?>">
                </div>
                <div class="form-group">
                    <label for="filter-field">Filter kolom</label>
                    <select id="filter-field" name="filter_field" class="form-control">
                        <option value="">Semua kolom</option>
                        <option value="jenjang" <?= $filterField === 'jenjang' ? 'selected' : '' ?>>Jenjang</option>
                        <option value="institusi" <?= $filterField === 'institusi' ? 'selected' : '' ?>>Institusi</option>
                        <option value="jurusan" <?= $filterField === 'jurusan' ? 'selected' : '' ?>>Jurusan</option>
                        <option value="tahun_mulai" <?= $filterField === 'tahun_mulai' ? 'selected' : '' ?>>Tahun Mulai</option>
                        <option value="tahun_selesai" <?= $filterField === 'tahun_selesai' ? 'selected' : '' ?>>Tahun Selesai</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="filter-value">Nilai filter</label>
                    <input id="filter-value" type="text" name="filter_value" class="form-control" placeholder="Masukkan kata kunci filter" value="<?= esc($filterValue) ?>">
                </div>
                <div class="form-group">
                    <label for="sort-by">Urutkan</label>
                    <select id="sort-by" name="sort_by" class="form-control">
                        <option value="id" <?= $sortBy === 'id' ? 'selected' : '' ?>>ID</option>
                        <option value="jenjang" <?= $sortBy === 'jenjang' ? 'selected' : '' ?>>Jenjang</option>
                        <option value="institusi" <?= $sortBy === 'institusi' ? 'selected' : '' ?>>Institusi</option>
                        <option value="jurusan" <?= $sortBy === 'jurusan' ? 'selected' : '' ?>>Jurusan</option>
                        <option value="tahun_mulai" <?= $sortBy === 'tahun_mulai' ? 'selected' : '' ?>>Tahun Mulai</option>
                        <option value="tahun_selesai" <?= $sortBy === 'tahun_selesai' ? 'selected' : '' ?>>Tahun Selesai</option>
                        <option value="created_at" <?= $sortBy === 'created_at' ? 'selected' : '' ?>>Tanggal dibuat</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="sort-dir">Arah urutan</label>
                    <select id="sort-dir" name="sort_dir" class="form-control">
                        <option value="asc" <?= $sortDir === 'asc' ? 'selected' : '' ?>>Naik (A-Z / 0-9)</option>
                        <option value="desc" <?= $sortDir === 'desc' ? 'selected' : '' ?>>Turun (Z-A / 9-0)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>&nbsp;</label>
                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                        <button type="submit" class="btn" style="padding: 10px 20px;">Terapkan</button>
                        <a href="<?= current_url() ?>" class="btn secondary" style="padding: 10px 20px;">Reset</a>
                    </div>
                </div>
            </form>
            <div class="muted" style="margin-top: 0.5rem;">
                Menampilkan <?= count($pendidikan ?? []) ?> dari <?= $totalRows ?> data (10 per halaman)
            </div>
        </div>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>
                            <a href="<?= $buildSortUrl('id') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                ID <?= $sortIcon('id') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('jenjang') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Jenjang <?= $sortIcon('jenjang') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('institusi') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Institusi <?= $sortIcon('institusi') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('jurusan') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Jurusan <?= $sortIcon('jurusan') ?>
                            </a>
                        </th>
                        <th>
                            <a href="<?= $buildSortUrl('tahun_selesai') ?>" style="color: inherit; text-decoration: none; display: inline-flex; align-items: center; gap: 0.35rem;">
                                Tahun <?= $sortIcon('tahun_selesai') ?>
                            </a>
                        </th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($pendidikan)): ?>
                        <?php foreach ($pendidikan as $item): ?>
                        <tr>
                            <td><?= esc($item['id']) ?></td>
                            <td><?= esc($item['jenjang']) ?></td>
                            <td><?= esc($item['institusi']) ?></td>
                            <td><?= esc($item['jurusan']) ?></td>
                            <td><?= esc($item['tahun_mulai']) ?> - <?= esc($item['tahun_selesai']) ?></td>
                            <td>
                                <a href="<?= base_url('admin/pendidikan/edit/' . $item['id']) ?>" class="btn" style="padding: 5px 15px; font-size: 0.9rem; margin-right: 5px;">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <form method="POST" action="<?= base_url('admin/pendidikan/delete/' . $item['id']) ?>" style="display:inline;">
                                    <?= csrf_field() ?>
                                    <button type="submit" class="btn" style="padding: 5px 15px; font-size: 0.9rem; background: #ef4444;" onclick="return confirm('Yakin ingin menghapus?')">
                                        <i class="fas fa-trash"></i> Hapus
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" style="text-align: center; padding: 2rem; color: #64748b;">
                                Belum ada data pendidikan
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if (isset($pager)): ?>
        <div class="pagination">
            <?= $pager->links('pendidikan', 'default_full') ?>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
