<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #0ea5e9;
            --secondary: #f97316;
            --dark: #0b1222;
            --muted: #94a3b8;
            --surface: #0f172a;
            --glass: rgba(255,255,255,0.15);
            --border: rgba(255,255,255,0.25);
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            min-height: 100vh;
            background:
                radial-gradient(circle at 12% 20%, rgba(14,165,233,0.16), transparent 26%),
                radial-gradient(circle at 82% 14%, rgba(249,115,22,0.14), transparent 30%),
                radial-gradient(circle at 30% 82%, rgba(34,197,94,0.12), transparent 26%),
                #eef2f7;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 24px;
            color: var(--dark);
        }
        .login-shell {
            position: relative;
            width: min(460px, 100%);
            perspective: 1400px;
        }
        .glow {
            position: absolute;
            inset: -8%;
            background: radial-gradient(circle, rgba(255,255,255,0.24), transparent 45%),
                        radial-gradient(circle, rgba(14,165,233,0.32), transparent 35%),
                        radial-gradient(circle, rgba(249,115,22,0.28), transparent 40%);
            filter: blur(80px);
            z-index: 0;
        }
        .cube-wrap {
            position: relative;
            transform-style: preserve-3d;
            width: 100%;
        }
        .login-container {
            position: relative;
            z-index: 1;
            background: linear-gradient(145deg, rgba(255,255,255,0.98), rgba(255,255,255,0.92));
            border-radius: 22px;
            padding: 34px;
            border: 1px solid rgba(14,165,233,0.12);
            box-shadow: 0 20px 52px rgba(15,23,42,0.16);
            overflow: hidden;
            transform-style: preserve-3d;
            animation: cubeFloat 14s ease-in-out infinite;
            will-change: transform;
            transform-origin: center;
        }
        .login-container::before,
        .login-container::after {
            content: '';
            position: absolute;
            top: 0;
            height: 100%;
            width: 18px;
            filter: none;
            border-radius: 12px;
            opacity: 0.7;
            box-shadow: inset 0 0 0 1px rgba(15,23,42,0.06);
        }
        .login-container::before {
            left: -9px;
            background: linear-gradient(180deg, #e0f2fe, #cbd5f5);
            transform-origin: right center;
            transform: rotateY(90deg) translateX(9px);
        }
        .login-container::after {
            right: -9px;
            background: linear-gradient(180deg, #e2e8f0, #cfd8e3);
            transform-origin: left center;
            transform: rotateY(-90deg) translateX(-9px);
        }
        .login-container:hover {
            animation-play-state: paused;
        }
        @keyframes cubeFloat {
            0%   { transform: rotateX(0deg) rotateY(0deg) translateY(0); }
            25%  { transform: rotateX(8deg) rotateY(-10deg) translateY(-10px); }
            50%  { transform: rotateX(-6deg) rotateY(8deg) translateY(8px); }
            75%  { transform: rotateX(6deg) rotateY(12deg) translateY(-8px); }
            100% { transform: rotateX(0deg) rotateY(0deg) translateY(0); }
        }
        .cube-reflection {
            position: absolute;
            bottom: -110px;
            left: 0;
            width: 100%;
            height: 110px;
            background: linear-gradient(145deg, rgba(255,255,255,0.85), rgba(255,255,255,0.75));
            transform-origin: top center;
            transform: rotateX(90deg) translateZ(-22px);
            border-radius: 18px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.18);
            opacity: 0.9;
            filter: blur(1px);
        }
        .login-header {
            text-align: center;
            margin-bottom: 1.5rem;
        }
        .login-header h1 {
            color: var(--primary);
            font-size: 2rem;
            margin-bottom: 0.4rem;
            letter-spacing: 0.3px;
        }
        .login-header p { color: #64748b; }
        .form-group { margin-bottom: 1.25rem; }
        .form-group label {
            display: block;
            margin-bottom: 0.4rem;
            color: #1e293b;
            font-weight: 600;
        }
        .input-wrap {
            position: relative;
        }
        .form-control {
            width: 100%;
            padding: 12px 14px;
            border-radius: 12px;
            border: 1.5px solid #dbeafe;
            background: rgba(255,255,255,0.92);
            color: #0f172a;
            font-family: 'Poppins', sans-serif;
            font-size: 1rem;
            transition: border-color 0.2s, box-shadow 0.2s, background 0.2s;
            box-shadow: inset 0 2px 6px rgba(15,23,42,0.06);
        }
        .form-control:focus {
            outline: none;
            border-color: rgba(14,165,233,0.8);
            box-shadow: 0 0 0 3px rgba(14,165,233,0.18), inset 0 2px 6px rgba(15,23,42,0.08);
            background: #fff;
        }
        .toggle-visibility {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #64748b;
            cursor: pointer;
            font-size: 1rem;
            padding: 6px;
        }
        .toggle-visibility:focus {
            outline: 2px solid rgba(14,165,233,0.6);
            outline-offset: 2px;
        }
        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #0ea5e9, #f97316);
            color: white;
            border: none;
            border-radius: 12px;
            font-family: 'Poppins', sans-serif;
            font-size: 1rem;
            font-weight: 700;
            letter-spacing: 0.2px;
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s, opacity 0.2s, left 0.25s ease;
            box-shadow: 0 16px 40px rgba(14,165,233,0.35);
            position: relative;
        }
        .btn:hover { transform: translateY(-1px); box-shadow: 0 20px 50px rgba(37,99,235,0.45); }
        .btn:active { transform: translateY(0); }
        .btn.dodge {
            transition: transform 0.25s ease, left 0.25s ease, box-shadow 0.2s;
        }
        .alert {
            padding: 12px;
            border-radius: 12px;
            margin-bottom: 1.25rem;
            background: #fee2e2;
            color: #b91c1c;
            border: 1px solid #fecdd3;
        }
        .back-link {
            text-align: center;
            margin-top: 1.2rem;
        }
        .back-link a {
            color: #475569;
            text-decoration: none;
            font-size: 0.95rem;
        }
        .back-link a:hover { color: #2563eb; }

        /* Cube preview */
        .cube-preview {
            position: relative;
            margin: 0 auto 18px;
            width: min(260px, 75%);
            aspect-ratio: 1 / 1;
            perspective: 1200px;
            filter: drop-shadow(0 10px 28px rgba(0,0,0,0.18));
        }
        .cube-top {
            position: absolute;
            top: -10px;
            left: 0;
            width: 100%;
            height: 18px;
            background: linear-gradient(135deg, rgba(14,165,233,0.16), rgba(249,115,22,0.14));
            border-radius: 14px;
            transform-origin: top center;
            transform: rotateX(90deg) translateY(9px);
            box-shadow: inset 0 0 0 1px rgba(15,23,42,0.06);
            opacity: 0.75;
        }
        .cube {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            transform-style: preserve-3d;
            animation: cubeLogin 16s infinite linear;
        }
        .cube:hover { animation-play-state: paused; }
        .cube-face {
            position: absolute;
            inset: 0;
            border-radius: 18px;
            overflow: hidden;
            backface-visibility: hidden;
            border: 2px solid rgba(255,255,255,0.35);
            box-shadow: inset 0 0 0 1px rgba(0,0,0,0.05), 0 12px 30px rgba(0,0,0,0.15);
            background-size: cover;
            background-position: center;
        }
        .cube-face::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.14), rgba(255,255,255,0));
        }
        .cube-face.front  { transform: translateZ(50%); }
        .cube-face.back   { transform: rotateY(180deg) translateZ(50%); }
        .cube-face.right  { transform: rotateY(90deg) translateZ(50%); }
        .cube-face.left   { transform: rotateY(-90deg) translateZ(50%); }
        .cube-face.top    { transform: rotateX(90deg) translateZ(50%); }
        .cube-face.bottom { transform: rotateX(-90deg) translateZ(50%); }
        .cube-shadow {
            position: absolute;
            inset: auto;
            width: 70%;
            height: 12%;
            background: radial-gradient(closest-side, rgba(0,0,0,0.22), rgba(0,0,0,0));
            bottom: -8%;
            left: 15%;
            filter: blur(10px);
            z-index: 0;
        }
        @keyframes cubeLogin {
            0%   { transform: rotateX(-18deg) rotateY(12deg); }
            50%  { transform: rotateX(24deg) rotateY(192deg); }
            100% { transform: rotateX(342deg) rotateY(372deg); }
        }

        /* Responsiveness */
        @media (max-width: 640px) {
            body { padding: 16px; }
            .login-container { padding: 26px 22px; border-radius: 18px; }
            .login-header h1 { font-size: 1.6rem; }
            .login-header p { font-size: 0.95rem; }
            .btn { font-size: 0.95rem; padding: 11px; }
        }
        @media (max-width: 420px) {
            body { padding: 12px; }
            .login-container { padding: 22px 18px; }
            .form-control { font-size: 0.95rem; }
            .login-header h1 { font-size: 1.45rem; }
        }
    </style>
</head>
<body>
    <div class="login-shell">
        <div class="glow"></div>
        <div class="cube-wrap">
            <div class="login-container" data-has-error="<?= isset($error) ? '1' : '0' ?>">
                <div class="cube-top"></div>
                <div class="cube-preview">
                    <?php
                        $texture = isset($previewFoto) && $previewFoto ? base_url(esc($previewFoto)) : '';
                        $bgStyle = $texture
                            ? 'background-image:url(' . $texture . ');'
                            : 'background-image:linear-gradient(135deg,#0ea5e9,#f97316);';
                    ?>
                    <div class="cube">
                        <div class="cube-face front"  style="<?= $bgStyle ?>"></div>
                        <div class="cube-face back"   style="<?= $bgStyle ?>"></div>
                        <div class="cube-face right"  style="<?= $bgStyle ?>"></div>
                        <div class="cube-face left"   style="<?= $bgStyle ?>"></div>
                        <div class="cube-face top"    style="<?= $bgStyle ?>"></div>
                        <div class="cube-face bottom" style="<?= $bgStyle ?>"></div>
                    </div>
                    <div class="cube-shadow"></div>
                </div>
                <div class="login-header">
                    <h1><i class="fas fa-lock"></i> Admin Login</h1>
                    <p>Masuk ke panel admin</p>
                </div>
                
                <?php if (isset($error)): ?>
                <div class="alert">
                    <i class="fas fa-exclamation-circle"></i> <?= esc($error) ?>
                </div>
                <?php endif; ?>
                
                <form method="POST" action="<?= base_url('admin/login') ?>" id="loginForm">
                    <!-- CSRF disabled for admin routes -->
                    <div class="form-group">
                        <label for="username"><i class="fas fa-user"></i> Username</label>
                        <input type="text" id="username" name="username" class="form-control" required autofocus value="">
                    </div>
                    
                <div class="form-group">
                    <label for="password"><i class="fas fa-key"></i> Password</label>
                    <div class="input-wrap">
                        <input type="password" id="password" name="password" class="form-control" required value="">
                        <button type="button" class="toggle-visibility" aria-label="Tampilkan password" id="togglePassword">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
                    
                    <button type="submit" class="btn" id="loginBtn">
                        <i class="fas fa-sign-in-alt"></i> Login
                    </button>
                </form>
                
                <div class="back-link">
                    <a href="<?= base_url() ?>"><i class="fas fa-arrow-left"></i> Kembali ke Home</a>
                </div>
            </div>
            <div class="cube-reflection"></div>
        </div>
    </div>
</body>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const container = document.querySelector('.login-container');
        const loginBtn = document.getElementById('loginBtn');
        const pwdInput = document.getElementById('password');
        const togglePwd = document.getElementById('togglePassword');

        // Toggle password visibility (always active)
        if (pwdInput && togglePwd) {
            togglePwd.addEventListener('click', () => {
                const isHidden = pwdInput.type === 'password';
                pwdInput.type = isHidden ? 'text' : 'password';
                togglePwd.innerHTML = isHidden ? '<i class="fas fa-eye-slash"></i>' : '<i class="fas fa-eye"></i>';
                togglePwd.setAttribute('aria-label', isHidden ? 'Sembunyikan password' : 'Tampilkan password');
            });
        }

        if (!container || !loginBtn) return;

        const hasError = container.dataset.hasError === '1';
        if (!hasError) return;

        // Move button away from cursor when hovered after error
        const maxShift = 60; // px
        loginBtn.classList.add('dodge');

        loginBtn.addEventListener('mouseenter', () => {
            const dir = Math.random() > 0.5 ? 1 : -1;
            const shift = Math.floor(Math.random() * maxShift) * dir;
            loginBtn.style.left = `${shift}px`;
        });

        // Reset position when mouse leaves
        loginBtn.addEventListener('mouseleave', () => {
            loginBtn.style.left = '0px';
        });
    });
</script>
</html>
