<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-plus"></i> Tambah Biodata</h1>
            <a href="<?= base_url('admin/biodata') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <form method="POST" action="<?= base_url('admin/biodata/create') ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Nama *</label>
                    <input type="text" name="nama" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label>Alamat</label>
                    <textarea name="alamat" class="form-control" rows="3"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Email *</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label>Telepon</label>
                    <input type="text" name="telepon" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Foto</label>
                    <input type="file" name="foto_file" class="form-control" accept="image/*">
                    <small class="muted">Pilih file dari komputer Anda (opsional). Jika dikosongkan, isi manual path di bawah ini.</small>
                </div>
                
                <div class="form-group">
                    <label>Path Foto (opsional)</label>
                    <input type="text" name="foto" class="form-control" placeholder="uploads/foto.jpg">
                </div>
                
                <div class="form-group">
                    <label>Tentang</label>
                    <textarea name="tentang" class="form-control" rows="5"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Keahlian</label>
                    <textarea name="keahlian" class="form-control" rows="3"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Pengalaman</label>
                    <textarea name="pengalaman" class="form-control" rows="3"></textarea>
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
