<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<style>
    .admin-header {
        background: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 1rem;
    }
    .multi-photo-inputs {
        display: grid;
        gap: 12px;
    }
    .photo-field {
        background: #f8fafc;
        border: 1px dashed #cbd5e1;
        border-radius: 12px;
        padding: 12px;
    }
</style>
<section style="padding-top: 100px;">
    <div class="container">
        <div class="admin-header">
            <h1><i class="fas fa-plus"></i> Tambah Aktivitas</h1>
            <a href="<?= base_url('admin/aktivitas') ?>" class="btn" style="padding: 10px 20px;">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        <div class="card">
            <form method="POST" action="<?= base_url('admin/aktivitas/create') ?>" enctype="multipart/form-data">
                <?= csrf_field() ?>
                <div class="form-group">
                    <label>Nama Aktivitas *</label>
                    <input type="text" name="nama_aktivitas" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Jam</label>
                    <input type="time" name="jam" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" class="form-control" rows="5"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Jenis *</label>
                    <select name="jenis" class="form-control" required>
                        <option value="">Pilih Jenis</option>
                        <option value="foto">Foto</option>
                        <option value="video">Video</option>
                    </select>
                </div>
                
                <div class="form-group" id="photo-count-group" style="display:none;">
                    <label>Jumlah Foto</label>
                    <select name="photo_count" id="photo-count" class="form-control">
                        <option value="2">2 foto</option>
                        <option value="3">3 foto</option>
                        <option value="4">4 foto</option>
                    </select>
                </div>

                <div class="form-group" id="photo-upload-wrapper" style="display:none;">
                    <label>Upload Foto</label>
                    <div id="photo-inputs" class="multi-photo-inputs"></div>
                    <small class="muted">Unggah 2-4 foto (JPG/PNG). Setiap foto punya tombol pilih file sendiri.</small>
                </div>

                <div class="form-group" id="video-upload-wrapper">
                    <label>Upload File</label>
                    <input type="file" name="file_upload" class="form-control" accept="image/*,video/*">
                    <small class="muted">Pilih file dari komputer Anda. Untuk foto wajib unggah file, bukan mengetik path.</small>
                </div>
                
                <button type="submit" class="btn">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const jenisSelect   = document.querySelector('select[name="jenis"]');
    const photoCount    = document.getElementById('photo-count');
    const photoGroup    = document.getElementById('photo-count-group');
    const photoWrapper  = document.getElementById('photo-upload-wrapper');
    const photoInputs   = document.getElementById('photo-inputs');
    const videoWrapper  = document.getElementById('video-upload-wrapper');

    function renderPhotoInputs(count) {
        photoInputs.innerHTML = '';
        const total = Math.min(4, Math.max(2, parseInt(count, 10) || 2));
        for (let i = 1; i <= total; i++) {
            const field = document.createElement('div');
            field.className = 'photo-field';
            field.innerHTML = `
                <label style="font-weight:600; display:block; margin-bottom:6px;">Foto ${i}</label>
                <input type="file" name="photo_uploads[]" class="form-control" accept="image/*" required>
            `;
            photoInputs.appendChild(field);
        }
    }

    function syncVisibility() {
        const isPhoto = jenisSelect.value === 'foto';
        photoGroup.style.display   = isPhoto ? 'block' : 'none';
        photoWrapper.style.display = isPhoto ? 'block' : 'none';
        videoWrapper.style.display = isPhoto ? 'none'  : 'block';
        if (isPhoto) {
            renderPhotoInputs(photoCount.value || 2);
        } else {
            photoInputs.innerHTML = '';
        }
    }

    jenisSelect.addEventListener('change', syncVisibility);
    photoCount.addEventListener('change', () => renderPhotoInputs(photoCount.value));

    // default state
    syncVisibility();
});
</script>
<?= $this->endSection() ?>
