<?= $this->extend('layouts/main') ?>

<?= $this->section('styles') ?>
<style>
    .cv-section {
        padding-top: 110px;
    }

    .cv-card {
        display: grid;
        grid-template-columns: 220px 1fr;
        gap: 1.75rem;
        align-items: start;
    }

    .cv-photo {
        width: 100%;
        max-width: 240px;
        border-radius: 15px;
        object-fit: cover;
        box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    }

    .cv-title {
        margin-bottom: 1rem;
        color: var(--primary-color);
    }

    .cv-info {
        width: 100%;
    }

    .cv-actions {
        margin-top: 1rem;
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }

    @media (max-width: 768px) {
        .cv-card {
            grid-template-columns: 1fr;
            justify-items: center;
        }

        .cv-card > div {
            width: 100%;
        }

        .cv-photo {
            margin: 0 auto;
            max-width: 260px;
        }

        .cv-title {
            font-size: 1.75rem;
        }

        .cv-actions {
            justify-content: center;
        }
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<section class="cv-section">
    <div class="container">
        <h2 class="section-title">Curriculum Vitae</h2>
        
        <?php if ($biodata): ?>
        <div class="card" style="margin-bottom: 2rem;">
            <div class="cv-card">
                <?php if (!empty($biodata['foto'])): ?>
                <div>
                    <img src="<?= base_url(esc($biodata['foto'])) ?>" alt="Foto" class="cv-photo">
                </div>
                <?php endif; ?>
                <div class="cv-info">
                    <h1 class="cv-title"><?= esc($biodata['nama']) ?></h1>
                    <p><strong>Email:</strong> <?= esc($biodata['email']) ?></p>
                    <p><strong>Telepon:</strong> <?= esc($biodata['telepon']) ?></p>
                    <p><strong>Alamat:</strong> <?= esc($biodata['alamat']) ?></p>
                    <div class="cv-actions">
                       
                        <a href="https://wa.me/6285719678058?text=Halo%20saya%20ingin%20berbicara" class="btn secondary" style="padding: 10px 20px; display:inline-flex; align-items:center; gap:8px;" target="_blank" rel="noopener">
                            <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
                        <a href="<?= base_url('cv') ?>#pengalaman" class="btn" style="padding: 10px 20px;">Lihat Pengalaman</a>
                    </div>
                </div>
            </div>
        </div>

        <?php if (!empty($biodata['tentang'])): ?>
        <div class="card" style="margin-bottom: 2rem;">
            <h3 style="margin-bottom: 1rem; color: var(--primary-color);">Tentang Saya</h3>
            <p><?= nl2br(esc($biodata['tentang'])) ?></p>
        </div>
        <?php endif; ?>

        <?php
        $skills = [];
        if (!empty($biodata['keahlian'])) {
            $skills = array_filter(array_map('trim', preg_split('/[,\\n]+/', $biodata['keahlian'])));
        }
        ?>
        <?php if (!empty($skills)): ?>
        <div class="card" style="margin-bottom: 2rem;">
            <h3 style="margin-bottom: 1rem; color: var(--primary-color);">Keahlian</h3>
            <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                <?php foreach ($skills as $skill): ?>
                    <span class="pill" style="background: #e0f2fe; color: #0369a1; border: 1px solid #bae6fd;"><?= esc($skill) ?></span>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <?php if (!empty($biodata['pengalaman'])): ?>
        <div id="pengalaman" class="card" style="margin-bottom: 2rem;">
            <h3 style="margin-bottom: 1rem; color: var(--primary-color);">Pengalaman</h3>
            <p><?= nl2br(esc($biodata['pengalaman'])) ?></p>
        </div>
        <?php endif; ?>
        <?php else: ?>
        <div class="empty-state">
            <p>Data biodata belum tersedia.</p>
        </div>
        <?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
