<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

<?php
    $search      = $search ?? '';
    $filterField = $filterField ?? '';
    $filterValue = $filterValue ?? '';
    $sortBy      = $sortBy ?? 'tanggal';
    $sortDir     = $sortDir ?? 'desc';
    $pageParam   = $pageParam ?? 'page_aktivitas';
    $perPage     = $perPage ?? 10;
    $totalRows   = isset($pager) ? $pager->getTotal('aktivitas') : count($aktivitas ?? []);
?>

<section style="padding-top: 100px;">
    <div class="container">
        <h2 class="section-title">Aktivitas</h2>

        <div class="filter-section">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label for="search-aktivitas">Pencarian</label>
                    <input id="search-aktivitas" type="text" name="search" class="form-control" placeholder="Cari nama, deskripsi, jenis..." value="<?= esc($search) ?>">
                </div>
                <div class="form-group">
                    <label for="filter-field">Filter kolom</label>
                    <select id="filter-field" name="filter_field" class="form-control">
                        <option value="">Semua kolom</option>
                        <option value="nama_aktivitas" <?= $filterField === 'nama_aktivitas' ? 'selected' : '' ?>>Nama Aktivitas</option>
                        <option value="jenis" <?= $filterField === 'jenis' ? 'selected' : '' ?>>Jenis</option>
                        <option value="tanggal" <?= $filterField === 'tanggal' ? 'selected' : '' ?>>Tanggal</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="filter-value">Nilai filter</label>
                    <input id="filter-value" type="text" name="filter_value" class="form-control" placeholder="Misal: foto, video, 2024-01-01" value="<?= esc($filterValue) ?>">
                </div>
                <div class="form-group">
                    <label for="sort-by">Urutkan</label>
                    <select id="sort-by" name="sort_by" class="form-control">
                        <option value="id" <?= $sortBy === 'id' ? 'selected' : '' ?>>ID</option>
                        <option value="nama_aktivitas" <?= $sortBy === 'nama_aktivitas' ? 'selected' : '' ?>>Nama Aktivitas</option>
                        <option value="tanggal" <?= $sortBy === 'tanggal' ? 'selected' : '' ?>>Tanggal</option>
                        <option value="jam" <?= $sortBy === 'jam' ? 'selected' : '' ?>>Jam</option>
                        <option value="jenis" <?= $sortBy === 'jenis' ? 'selected' : '' ?>>Jenis</option>
                        <option value="created_at" <?= $sortBy === 'created_at' ? 'selected' : '' ?>>Tanggal dibuat</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="sort-dir">Arah urutan</label>
                    <select id="sort-dir" name="sort_dir" class="form-control">
                        <option value="asc" <?= $sortDir === 'asc' ? 'selected' : '' ?>>Naik (A-Z / 0-9)</option>
                        <option value="desc" <?= $sortDir === 'desc' ? 'selected' : '' ?>>Turun (Z-A / 9-0)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>&nbsp;</label>
                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                        <button type="submit" class="btn" style="padding: 10px 20px;">Terapkan</button>
                        <a href="<?= current_url() ?>" class="btn secondary" style="padding: 10px 20px;">Reset</a>
                    </div>
                </div>
            </form>
            <div class="muted" style="margin-top: 0.5rem;">
                Data publik hanya dapat dibaca. Menampilkan <?= count($aktivitas ?? []) ?> dari <?= $totalRows ?> aktivitas (<?= $perPage ?> per halaman).
            </div>
        </div>

<?php if (!empty($aktivitas)): ?>
<div class="gallery">
    <?php foreach ($aktivitas as $item): ?>
    <?php
        $mediaFiles = $item['media_files'] ?? [];
        if (empty($mediaFiles) && !empty($item['file_path'])) {
            $decoded = json_decode($item['file_path'], true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                $mediaFiles = array_values(array_filter($decoded));
            } elseif (!empty($item['file_path'])) {
                $mediaFiles = [$item['file_path']];
            }
        }
        $coverPath  = $mediaFiles[0] ?? ($item['file_path'] ?? null);
        $mediaCount = count($mediaFiles);
    ?>
    <div class="gallery-item">
        <a href="<?= base_url('aktivitas/' . $item['id']) ?>" style="display:block; width:100%; height:100%; text-decoration:none; color:inherit;">
            <?php if ($item['jenis'] === 'foto' && !empty($coverPath)): ?>
                <img src="<?= base_url(esc($coverPath)) ?>" alt="<?= esc($item['nama_aktivitas']) ?>">
            <?php elseif ($item['jenis'] === 'video' && !empty($coverPath)): ?>
                <video controls>
                    <source src="<?= base_url(esc($coverPath)) ?>" type="video/mp4">
                    Browser Anda tidak mendukung video tag.
                </video>
            <?php else: ?>
                <div style="width: 100%; height: 100%; background: var(--gradient); display: flex; align-items: center; justify-content: center; color: white; font-size: 3rem;">
                    <i class="fas fa-<?= $item['jenis'] === 'foto' ? 'image' : 'video' ?>"></i>
                </div>
            <?php endif; ?>
            <div class="gallery-overlay">
                <h4 style="margin-bottom: 0.5rem;"><?= esc($item['nama_aktivitas']) ?></h4>
                <?php if (!empty($item['tanggal'])): ?>
                <p style="font-size: 0.9rem; margin-bottom: 0.5rem;">
                    <i class="fas fa-calendar"></i> <?= date('d F Y', strtotime($item['tanggal'])) ?>
                    <?php if (!empty($item['jam'])): ?>
                    <i class="fas fa-clock" style="margin-left: 1rem;"></i> <?= date('H:i', strtotime($item['jam'])) ?>
                    <?php endif; ?>
                </p>
                <?php endif; ?>
                <?php if (!empty($item['deskripsi'])): ?>
                <p style="font-size: 0.9rem;"><?= esc($item['deskripsi']) ?></p>
                <?php endif; ?>
                <span class="pill" style="background: rgba(0,0,0,0.6); color: #fff; border: 1px solid rgba(255,255,255,0.2);">
                    <?php if ($item['jenis'] === 'foto' && $mediaCount > 1): ?>
                        <?= $mediaCount ?> Foto
                    <?php else: ?>
                        Lihat Detail
                    <?php endif; ?>
                </span>
            </div>
        </a>
    </div>
    <?php endforeach; ?>
</div>

<?php if (isset($pager)): ?>
    <div class="pagination">
        <?= $pager->links('aktivitas', 'default_full') ?>
    </div>
<?php endif; ?>

<?php else: ?>
<div class="empty-state">
    <p>Data aktivitas belum tersedia.</p>
</div>
<?php endif; ?>
    </div>
</section>
<?= $this->endSection() ?>
